/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.upgrade.get;

import io.skylite.core.action.admin.indices.upgrade.get.ShardUpgradeStatus;
import io.skylite.core.index.shard.ShardId;
import java.util.Arrays;
import java.util.Iterator;

public class IndexShardUpgradeStatus
implements Iterable<ShardUpgradeStatus> {
    private final ShardId shardId;
    private final ShardUpgradeStatus[] shards;

    IndexShardUpgradeStatus(ShardId shardId, ShardUpgradeStatus[] shards) {
        this.shardId = shardId;
        this.shards = shards;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public ShardUpgradeStatus getAt(int i) {
        return this.shards[i];
    }

    public ShardUpgradeStatus[] getShards() {
        return this.shards;
    }

    @Override
    public Iterator<ShardUpgradeStatus> iterator() {
        return Arrays.stream(this.shards).iterator();
    }

    public long getTotalBytes() {
        long totalBytes = 0L;
        for (ShardUpgradeStatus indexShardUpgradeStatus : this.shards) {
            totalBytes += indexShardUpgradeStatus.getTotalBytes();
        }
        return totalBytes;
    }

    public long getToUpgradeBytes() {
        long upgradeBytes = 0L;
        for (ShardUpgradeStatus indexShardUpgradeStatus : this.shards) {
            upgradeBytes += indexShardUpgradeStatus.getToUpgradeBytes();
        }
        return upgradeBytes;
    }

    public long getToUpgradeBytesAncient() {
        long upgradeBytesAncient = 0L;
        for (ShardUpgradeStatus indexShardUpgradeStatus : this.shards) {
            upgradeBytesAncient += indexShardUpgradeStatus.getToUpgradeBytesAncient();
        }
        return upgradeBytesAncient;
    }
}

