/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.upgrade.post;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.shard.ShardId;
import java.io.IOException;
import java.text.ParseException;

public class ShardUpgradeResult
implements Writeable {
    private ShardId shardId;
    private org.apache.lucene.util.Version oldestLuceneSegment;
    private Version upgradeVersion;
    private boolean primary;

    public ShardUpgradeResult(ShardId shardId, boolean primary, Version upgradeVersion, org.apache.lucene.util.Version oldestLuceneSegment) {
        this.shardId = shardId;
        this.primary = primary;
        this.upgradeVersion = upgradeVersion;
        this.oldestLuceneSegment = oldestLuceneSegment;
    }

    public ShardUpgradeResult(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.primary = in.readBoolean();
        this.upgradeVersion = in.readVersion();
        try {
            this.oldestLuceneSegment = org.apache.lucene.util.Version.parse((String)in.readString());
        }
        catch (ParseException ex) {
            throw new IOException("failed to parse lucene version [" + String.valueOf(this.oldestLuceneSegment) + "]", ex);
        }
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public org.apache.lucene.util.Version oldestLuceneSegment() {
        return this.oldestLuceneSegment;
    }

    public Version upgradeVersion() {
        return this.upgradeVersion;
    }

    public boolean primary() {
        return this.primary;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeBoolean(this.primary);
        out.writeVersion(this.upgradeVersion);
        out.writeString(this.oldestLuceneSegment.toString());
    }
}

