/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.validate;

import io.skylite.OpenSearchVersion;
import io.skylite.core.action.admin.indices.validate.ValidateQueryRequest;
import io.skylite.core.action.support.broadcast.BroadcastShardRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.search.internal.AliasFilter;
import java.io.IOException;
import java.util.Objects;

public class ShardValidateQueryRequest
extends BroadcastShardRequest {
    private QueryBuilder query;
    private boolean explain;
    private boolean rewrite;
    private long nowInMillis;
    private AliasFilter filteringAliases;

    public ShardValidateQueryRequest(StreamInput in) throws IOException {
        super(in);
        int typesSize;
        this.query = in.readNamedWriteable(QueryBuilder.class);
        if (in.getVersion().before(OpenSearchVersion.V_2_0_0) && (typesSize = in.readVInt()) > 0) {
            for (int i = 0; i < typesSize; ++i) {
                in.readString();
            }
        }
        this.filteringAliases = new AliasFilter(in);
        this.explain = in.readBoolean();
        this.rewrite = in.readBoolean();
        this.nowInMillis = in.readVLong();
    }

    public ShardValidateQueryRequest(ShardId shardId, AliasFilter filteringAliases, ValidateQueryRequest request) {
        super(shardId, request);
        this.query = request.query();
        this.explain = request.explain();
        this.rewrite = request.rewrite();
        this.filteringAliases = Objects.requireNonNull(filteringAliases, "filteringAliases must not be null");
        this.nowInMillis = request.nowInMillis;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public boolean explain() {
        return this.explain;
    }

    public boolean rewrite() {
        return this.rewrite;
    }

    public AliasFilter filteringAliases() {
        return this.filteringAliases;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable(this.query);
        if (out.getVersion().before(OpenSearchVersion.V_2_0_0)) {
            out.writeVInt(0);
        }
        this.filteringAliases.writeTo(out);
        out.writeBoolean(this.explain);
        out.writeBoolean(this.rewrite);
        out.writeVLong(this.nowInMillis);
    }
}

