/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.validate;

import io.skylite.OpenSearchVersion;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.action.support.broadcast.BroadcastRequest;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;

public class ValidateQueryRequest
extends BroadcastRequest<ValidateQueryRequest>
implements ToXContentObject {
    private QueryBuilder query = new MatchAllQueryBuilder();
    private boolean explain;
    private boolean rewrite;
    private boolean allShards;
    long nowInMillis;

    public ValidateQueryRequest() {
        this(Strings.EMPTY_ARRAY);
    }

    public ValidateQueryRequest(StreamInput in) throws IOException {
        super(in);
        int typesSize;
        this.query = in.readNamedWriteable(QueryBuilder.class);
        if (in.getVersion().before(OpenSearchVersion.V_2_0_0) && (typesSize = in.readVInt()) > 0) {
            for (int i = 0; i < typesSize; ++i) {
                in.readString();
            }
        }
        this.explain = in.readBoolean();
        this.rewrite = in.readBoolean();
        this.allShards = in.readBoolean();
    }

    public ValidateQueryRequest(String ... indices) {
        super(indices);
        this.indicesOptions(IndicesOptions.fromOptions(false, false, true, false));
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.query == null) {
            validationException = ValidateActions.addValidationError((String)"query cannot be null", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public ValidateQueryRequest query(QueryBuilder query) {
        this.query = query;
        return this;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public void setNowInMillis(long nowInMillis) {
        this.nowInMillis = nowInMillis;
    }

    public void explain(boolean explain) {
        this.explain = explain;
    }

    public boolean explain() {
        return this.explain;
    }

    public void rewrite(boolean rewrite) {
        this.rewrite = rewrite;
    }

    public boolean rewrite() {
        return this.rewrite;
    }

    public void allShards(boolean allShards) {
        this.allShards = allShards;
    }

    public boolean allShards() {
        return this.allShards;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable(this.query);
        if (out.getVersion().before(OpenSearchVersion.V_2_0_0)) {
            out.writeVInt(0);
        }
        out.writeBoolean(this.explain);
        out.writeBoolean(this.rewrite);
        out.writeBoolean(this.allShards);
    }

    public String toString() {
        return "[" + Arrays.toString(this.indices) + "] query[" + String.valueOf(this.query) + "], explain:" + this.explain + ", rewrite:" + this.rewrite + ", all_shards:" + this.allShards;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("query");
        this.query.toXContent(builder, params);
        return builder.endObject();
    }
}

