/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.bulk;

import io.skylite.common.Nullable;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequestBuilder;
import io.skylite.core.action.bulk.BulkAction;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteRequestBuilder;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexRequestBuilder;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.WriteRequestBuilder;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateRequestBuilder;
import io.skylite.core.client.SkyliteClient;
import io.skylite.core.xcontent.MediaType;

public class BulkRequestBuilder
extends ActionRequestBuilder<BulkRequest, BulkResponse>
implements WriteRequestBuilder<BulkRequestBuilder> {
    public BulkRequestBuilder(SkyliteClient client, BulkAction action, @Nullable String globalIndex) {
        super(client, action, new BulkRequest(globalIndex));
    }

    public BulkRequestBuilder(SkyliteClient client, BulkAction action) {
        super(client, action, new BulkRequest());
    }

    public BulkRequestBuilder add(IndexRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(IndexRequestBuilder request) {
        ((BulkRequest)this.request).add((IndexRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(DeleteRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(DeleteRequestBuilder request) {
        ((BulkRequest)this.request).add((DeleteRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(UpdateRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(UpdateRequestBuilder request) {
        ((BulkRequest)this.request).add((UpdateRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(byte[] data, int from, int length, MediaType xContentType) throws Exception {
        ((BulkRequest)this.request).add(data, from, length, null, xContentType);
        return this;
    }

    public BulkRequestBuilder add(byte[] data, int from, int length, @Nullable String defaultIndex, MediaType mediaType) throws Exception {
        ((BulkRequest)this.request).add(data, from, length, defaultIndex, mediaType);
        return this;
    }

    public BulkRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((BulkRequest)this.request).waitForActiveShards(waitForActiveShards);
        return this;
    }

    public BulkRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public final BulkRequestBuilder setTimeout(TimeValue timeout) {
        ((BulkRequest)this.request).timeout(timeout);
        return this;
    }

    public final BulkRequestBuilder setTimeout(String timeout) {
        ((BulkRequest)this.request).timeout(timeout);
        return this;
    }

    public int numberOfActions() {
        return ((BulkRequest)this.request).numberOfActions();
    }

    public BulkRequestBuilder pipeline(String globalPipeline) {
        ((BulkRequest)this.request).pipeline(globalPipeline);
        return this;
    }

    public BulkRequestBuilder routing(String globalRouting) {
        ((BulkRequest)this.request).routing(globalRouting);
        return this;
    }
}

