/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.bulk;

import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.WriteResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.ShardId;
import java.io.IOException;

public class BulkShardResponse
extends ReplicationResponse
implements WriteResponse {
    private final ShardId shardId;
    private final BulkItemResponse[] responses;

    public BulkShardResponse(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.responses = in.readArray(i -> new BulkItemResponse(this.shardId, i), BulkItemResponse[]::new);
    }

    public BulkShardResponse(ShardId shardId, BulkItemResponse[] responses) {
        this.shardId = shardId;
        this.responses = responses;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BulkItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public void setForcedRefresh(boolean forcedRefresh) {
        for (BulkItemResponse response : this.responses) {
            Object r = response.getResponse();
            if (r == null) continue;
            ((DocWriteResponse)r).setForcedRefresh(forcedRefresh);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeArray((o, item) -> item.writeThin(out), this.responses);
    }
}

