/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.clustermanager;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public abstract class AcknowledgedRequest<Request extends ClusterManagerNodeRequest<Request>>
extends ClusterManagerNodeRequest<Request>
implements AckedRequest {
    public static final TimeValue DEFAULT_ACK_TIMEOUT = TimeValue.timeValueSeconds((long)30L);
    public static final TimeValue DEFAULT_TASK_EXECUTION_TIMEOUT = TimeValue.timeValueHours((long)1L);
    protected TimeValue timeout = DEFAULT_ACK_TIMEOUT;

    protected AcknowledgedRequest() {
    }

    protected AcknowledgedRequest(StreamInput in) throws IOException {
        super(in);
        this.timeout = in.readTimeValue();
    }

    public final Request timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue((String)timeout, (TimeValue)this.timeout, (String)(this.getClass().getSimpleName() + ".timeout"));
        return (Request)this;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final TimeValue timeout() {
        return this.timeout;
    }

    @Override
    public TimeValue ackTimeout() {
        return this.timeout;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeTimeValue(this.timeout);
    }
}

