/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.clustermanager.info;

import io.skylite.OpenSearchVersion;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeReadRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public abstract class ClusterInfoRequest<Request extends ClusterInfoRequest<Request>>
extends ClusterManagerNodeReadRequest<Request>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public ClusterInfoRequest() {
    }

    public ClusterInfoRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        if (in.getVersion().before(OpenSearchVersion.V_2_0_0)) {
            in.readStringArray();
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        if (out.getVersion().before(OpenSearchVersion.V_2_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        this.indicesOptions.writeIndicesOptions(out);
    }

    public Request indices(String ... indices) {
        this.indices = indices;
        return (Request)this;
    }

    public Request indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return (Request)this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }
}

