/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.fieldcaps;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.shard.ShardId;
import java.io.IOException;
import java.util.Objects;

public class FieldCapabilitiesIndexRequest
extends ActionRequest
implements IndicesRequest {
    public static final IndicesOptions INDICES_OPTIONS = IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    private final String index;
    private final String[] fields;
    private final OriginalIndices originalIndices;
    private final QueryBuilder indexFilter;
    private final long nowInMillis;
    private ShardId shardId;

    public FieldCapabilitiesIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.shardId = in.readOptionalWriteable(ShardId::new);
        this.index = in.readOptionalString();
        this.fields = in.readStringArray();
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        this.indexFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nowInMillis = in.readLong();
    }

    public FieldCapabilitiesIndexRequest(String[] fields, String index, OriginalIndices originalIndices, QueryBuilder indexFilter, long nowInMillis) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("specified fields can't be null or empty");
        }
        this.index = Objects.requireNonNull(index);
        this.fields = fields;
        this.originalIndices = originalIndices;
        this.indexFilter = indexFilter;
        this.nowInMillis = nowInMillis;
    }

    public String[] fields() {
        return this.fields;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    public String index() {
        return this.index;
    }

    public QueryBuilder indexFilter() {
        return this.indexFilter;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public FieldCapabilitiesIndexRequest shardId(ShardId shardId) {
        this.shardId = shardId;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.shardId);
        out.writeOptionalString(this.index);
        out.writeStringArray(this.fields);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        out.writeOptionalNamedWriteable(this.indexFilter);
        out.writeLong(this.nowInMillis);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

