/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.fieldcaps;

import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.fieldcaps.FieldCapabilities;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesIndexResponse;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FieldCapabilitiesResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private final String[] indices;
    private final Map<String, Map<String, FieldCapabilities>> responseMap;
    private final List<FieldCapabilitiesIndexResponse> indexResponses;
    private static final ConstructingObjectParser<FieldCapabilitiesResponse, Void> PARSER = new ConstructingObjectParser("field_capabilities_response", true, a -> {
        List indices = a[0] == null ? Collections.emptyList() : (List)a[0];
        return new FieldCapabilitiesResponse((String[])indices.stream().toArray(String[]::new), ((List)a[1]).stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2)));
    });

    public FieldCapabilitiesResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> responseMap) {
        this(indices, responseMap, Collections.emptyList());
    }

    public FieldCapabilitiesResponse(List<FieldCapabilitiesIndexResponse> indexResponses) {
        this(Strings.EMPTY_ARRAY, Collections.emptyMap(), indexResponses);
    }

    private FieldCapabilitiesResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> responseMap, List<FieldCapabilitiesIndexResponse> indexResponses) {
        this.responseMap = Objects.requireNonNull(responseMap);
        this.indexResponses = Objects.requireNonNull(indexResponses);
        this.indices = indices;
    }

    public FieldCapabilitiesResponse(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.responseMap = in.readMap(StreamInput::readString, FieldCapabilitiesResponse::readField);
        this.indexResponses = in.readList(FieldCapabilitiesIndexResponse::new);
    }

    public FieldCapabilitiesResponse() {
        this(Strings.EMPTY_ARRAY, Collections.emptyMap(), Collections.emptyList());
    }

    public String[] getIndices() {
        return this.indices;
    }

    public Map<String, Map<String, FieldCapabilities>> get() {
        return this.responseMap;
    }

    public List<FieldCapabilitiesIndexResponse> getIndexResponses() {
        return this.indexResponses;
    }

    public Map<String, FieldCapabilities> getField(String field) {
        return this.responseMap.get(field);
    }

    private static Map<String, FieldCapabilities> readField(StreamInput in) throws IOException {
        return in.readMap(StreamInput::readString, FieldCapabilities::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.indices);
        out.writeMap(this.responseMap, StreamOutput::writeString, FieldCapabilitiesResponse::writeField);
        out.writeList(this.indexResponses);
    }

    private static void writeField(StreamOutput out, Map<String, FieldCapabilities> map) throws IOException {
        out.writeMap(map, StreamOutput::writeString, (valueOut, fc) -> fc.writeTo(valueOut));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.indexResponses.size() > 0) {
            throw new IllegalStateException("cannot serialize non-merged response");
        }
        builder.startObject();
        builder.field(INDICES_FIELD.getPreferredName(), (Object)this.indices);
        builder.field(FIELDS_FIELD.getPreferredName(), (Object)this.responseMap);
        builder.endObject();
        return builder;
    }

    public static FieldCapabilitiesResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    private static Map<String, FieldCapabilities> parseTypeToCapabilities(XContentParser parser, String name) throws IOException {
        XContentParser.Token token;
        HashMap<String, FieldCapabilities> typeToCapabilities = new HashMap<String, FieldCapabilities>();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            String type = parser.currentName();
            FieldCapabilities capabilities = FieldCapabilities.fromXContent(name, parser);
            typeToCapabilities.put(type, capabilities);
        }
        return typeToCapabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesResponse that = (FieldCapabilitiesResponse)o;
        return Arrays.equals(this.indices, that.indices) && Objects.equals(this.responseMap, that.responseMap) && Objects.equals(this.indexResponses, that.indexResponses);
    }

    public int hashCode() {
        int result = Objects.hash(this.responseMap, this.indexResponses);
        result = 31 * result + Arrays.hashCode(this.indices);
        return result;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), INDICES_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            Map<String, FieldCapabilities> typeToCapabilities = FieldCapabilitiesResponse.parseTypeToCapabilities(p, n);
            return new Tuple((Object)n, typeToCapabilities);
        }, FIELDS_FIELD);
    }
}

