/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.ingest;

import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.ingest.PipelineConfiguration;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.StatusToXContentObject;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class GetPipelineResponse
extends ActionResponse
implements StatusToXContentObject {
    private List<PipelineConfiguration> pipelines;

    public GetPipelineResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.pipelines = new ArrayList<PipelineConfiguration>(size);
        for (int i = 0; i < size; ++i) {
            this.pipelines.add(PipelineConfiguration.readFrom(in));
        }
    }

    public GetPipelineResponse(List<PipelineConfiguration> pipelines) {
        this.pipelines = pipelines;
    }

    public List<PipelineConfiguration> pipelines() {
        return Collections.unmodifiableList(this.pipelines);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.pipelines.size());
        for (PipelineConfiguration pipeline : this.pipelines) {
            pipeline.writeTo(out);
        }
    }

    public boolean isFound() {
        return !this.pipelines.isEmpty();
    }

    @Override
    public RestStatus status() {
        return this.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (PipelineConfiguration pipeline : this.pipelines) {
            builder.field(pipeline.getId(), pipeline.getConfigAsMap());
        }
        builder.endObject();
        return builder;
    }

    public static GetPipelineResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        ArrayList<PipelineConfiguration> pipelines = new ArrayList<PipelineConfiguration>();
        while (parser.nextToken().equals((Object)XContentParser.Token.FIELD_NAME)) {
            String pipelineId = parser.currentName();
            parser.nextToken();
            XContentBuilder contentBuilder = XContentBuilder.builder(parser.contentType().xContent());
            try {
                contentBuilder.generator().copyCurrentStructure(parser);
                PipelineConfiguration pipeline = new PipelineConfiguration(pipelineId, BytesReference.bytes(contentBuilder), contentBuilder.contentType());
                pipelines.add(pipeline);
            }
            finally {
                if (contentBuilder == null) continue;
                contentBuilder.close();
            }
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.currentToken(), parser);
        return new GetPipelineResponse(pipelines);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof GetPipelineResponse) {
            GetPipelineResponse otherResponse = (GetPipelineResponse)other;
            if (this.pipelines == null) {
                return otherResponse.pipelines == null;
            }
            if (otherResponse.pipelines == null) {
                return false;
            }
            if (otherResponse.pipelines.size() != this.pipelines.size()) {
                return false;
            }
            HashMap<String, PipelineConfiguration> otherPipelineMap = new HashMap<String, PipelineConfiguration>();
            for (PipelineConfiguration pipeline : otherResponse.pipelines) {
                otherPipelineMap.put(pipeline.getId(), pipeline);
            }
            for (PipelineConfiguration pipeline : this.pipelines) {
                PipelineConfiguration otherPipeline;
                if (pipeline.equals(otherPipeline = (PipelineConfiguration)otherPipelineMap.get(pipeline.getId()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public int hashCode() {
        int result = 1;
        for (PipelineConfiguration pipeline : this.pipelines) {
            result += pipeline == null ? 0 : pipeline.hashCode();
        }
        return result;
    }
}

