/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.ingest;

import io.skylite.SkyliteException;
import io.skylite.core.ParseField;
import io.skylite.core.action.ingest.SimulateDocumentResult;
import io.skylite.core.action.ingest.WriteableIngestDocument;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;

public final class SimulateDocumentBaseResult
implements SimulateDocumentResult {
    private final WriteableIngestDocument ingestDocument;
    private final Exception failure;
    public static final ConstructingObjectParser<SimulateDocumentBaseResult, Void> PARSER = new ConstructingObjectParser("simulate_document_base_result", true, a -> {
        if (a[1] == null) {
            assert (a[0] != null);
            return new SimulateDocumentBaseResult(((WriteableIngestDocument)a[0]).getIngestDocument());
        }
        assert (a[0] == null);
        return new SimulateDocumentBaseResult((SkyliteException)a[1]);
    });

    public SimulateDocumentBaseResult(IngestDocument ingestDocument) {
        this.ingestDocument = ingestDocument != null ? new WriteableIngestDocument(ingestDocument) : null;
        this.failure = null;
    }

    public SimulateDocumentBaseResult(Exception failure) {
        this.ingestDocument = null;
        this.failure = failure;
    }

    public SimulateDocumentBaseResult(StreamInput in) throws IOException {
        this.failure = in.readException();
        this.ingestDocument = in.readOptionalWriteable(WriteableIngestDocument::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeException(this.failure);
        out.writeOptionalWriteable(this.ingestDocument);
    }

    public IngestDocument getIngestDocument() {
        if (this.ingestDocument == null) {
            return null;
        }
        return this.ingestDocument.getIngestDocument();
    }

    public Exception getFailure() {
        return this.failure;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.failure == null && this.ingestDocument == null) {
            builder.nullValue();
            return builder;
        }
        builder.startObject();
        if (this.failure == null) {
            this.ingestDocument.toXContent(builder, params);
        } else {
            SkyliteException.generateFailureXContent(builder, params, this.failure, true);
        }
        builder.endObject();
        return builder;
    }

    public static SimulateDocumentBaseResult fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), WriteableIngestDocument.INGEST_DOC_PARSER, new ParseField("doc", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SkyliteException.fromXContent(p), new ParseField("error", new String[0]));
    }
}

