/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.resync;

import io.skylite.core.action.support.replication.ReplicatedWriteRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.translog.TranslogOperation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public final class ResyncReplicationRequest
extends ReplicatedWriteRequest<ResyncReplicationRequest> {
    private final long trimAboveSeqNo;
    private final TranslogOperation[] operations;
    private final long maxSeenAutoIdTimestampOnPrimary;

    public ResyncReplicationRequest(StreamInput in) throws IOException {
        super(in);
        this.trimAboveSeqNo = in.readZLong();
        this.maxSeenAutoIdTimestampOnPrimary = in.readZLong();
        this.operations = in.readArray(TranslogOperation::readOperation, TranslogOperation[]::new);
    }

    public ResyncReplicationRequest(ShardId shardId, long trimAboveSeqNo, long maxSeenAutoIdTimestampOnPrimary, TranslogOperation[] operations) {
        super(shardId);
        this.trimAboveSeqNo = trimAboveSeqNo;
        this.maxSeenAutoIdTimestampOnPrimary = maxSeenAutoIdTimestampOnPrimary;
        this.operations = operations;
    }

    public long getTrimAboveSeqNo() {
        return this.trimAboveSeqNo;
    }

    public long getMaxSeenAutoIdTimestampOnPrimary() {
        return this.maxSeenAutoIdTimestampOnPrimary;
    }

    public TranslogOperation[] getOperations() {
        return this.operations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeZLong(this.trimAboveSeqNo);
        out.writeZLong(this.maxSeenAutoIdTimestampOnPrimary);
        out.writeArray(TranslogOperation::writeOperation, this.operations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResyncReplicationRequest that = (ResyncReplicationRequest)o;
        return this.trimAboveSeqNo == that.trimAboveSeqNo && this.maxSeenAutoIdTimestampOnPrimary == that.maxSeenAutoIdTimestampOnPrimary && Arrays.equals(this.operations, that.operations);
    }

    public int hashCode() {
        return Objects.hash(this.trimAboveSeqNo, this.maxSeenAutoIdTimestampOnPrimary, this.operations);
    }

    @Override
    public String toString() {
        return "TransportResyncReplicationAction.Request{shardId=" + String.valueOf(this.shardId) + ", timeout=" + String.valueOf(this.timeout) + ", index='" + this.index + "', trimAboveSeqNo=" + this.trimAboveSeqNo + ", maxSeenAutoIdTimestampOnPrimary=" + this.maxSeenAutoIdTimestampOnPrimary + ", ops=" + this.operations.length + "}";
    }
}

