/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.core.ParseField;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.search.ShardSearchFailure;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.rest.RestUtils;
import io.skylite.core.xcontent.StatusToXContentObject;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;

public class CreatePitResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField ID = new ParseField("pit_id", new String[0]);
    private static final ParseField CREATION_TIME = new ParseField("creation_time", new String[0]);
    private final String id;
    private final int totalShards;
    private final int successfulShards;
    private final int failedShards;
    private final int skippedShards;
    private final ShardSearchFailure[] shardFailures;
    private final long creationTime;

    public CreatePitResponse(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
        this.skippedShards = in.readVInt();
        this.creationTime = in.readLong();
        int size = in.readVInt();
        if (size == 0) {
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        } else {
            this.shardFailures = new ShardSearchFailure[size];
            for (int i = 0; i < this.shardFailures.length; ++i) {
                this.shardFailures[i] = ShardSearchFailure.readShardSearchFailure(in);
            }
        }
    }

    public CreatePitResponse(String id, long creationTime, int totalShards, int successfulShards, int skippedShards, int failedShards, ShardSearchFailure[] shardFailures) {
        this.id = id;
        this.creationTime = creationTime;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.skippedShards = skippedShards;
        this.failedShards = failedShards;
        this.shardFailures = shardFailures;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        RestUtils.buildBroadcastShardsHeader(builder, params, this.getTotalShards(), this.getSuccessfulShards(), this.getSkippedShards(), this.getFailedShards(), this.getShardFailures());
        builder.field(CREATION_TIME.getPreferredName(), this.creationTime);
        builder.endObject();
        return builder;
    }

    public static CreatePitResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        parser.nextToken();
        return CreatePitResponse.innerFromXContent(parser);
    }

    public static CreatePitResponse innerFromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
        String currentFieldName = parser.currentName();
        int successfulShards = -1;
        int totalShards = -1;
        int skippedShards = 0;
        int failedShards = 0;
        String id = null;
        long creationTime = 0L;
        ArrayList<ShardSearchFailure> failures = new ArrayList<ShardSearchFailure>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            } else if (token.isValue()) {
                if (CREATION_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                    creationTime = parser.longValue();
                } else if (ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    id = parser.text();
                } else {
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                if (RestUtils._SHARDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (RestUtils.FAILED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                failedShards = parser.intValue();
                                continue;
                            }
                            if (RestUtils.SUCCESSFUL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                successfulShards = parser.intValue();
                                continue;
                            }
                            if (RestUtils.TOTAL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                totalShards = parser.intValue();
                                continue;
                            }
                            if (RestUtils.SKIPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                skippedShards = parser.intValue();
                                continue;
                            }
                            parser.skipChildren();
                            continue;
                        }
                        if (token == XContentParser.Token.START_ARRAY) {
                            if (RestUtils.FAILURES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    failures.add(ShardSearchFailure.fromXContent(parser));
                                }
                                continue;
                            }
                            parser.skipChildren();
                            continue;
                        }
                        parser.skipChildren();
                    }
                } else {
                    parser.skipChildren();
                }
            }
            token = parser.nextToken();
        }
        return new CreatePitResponse(id, creationTime, totalShards, successfulShards, skippedShards, failedShards, failures.toArray(ShardSearchFailure.EMPTY_ARRAY));
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getFailedShards() {
        return this.shardFailures.length;
    }

    public ShardSearchFailure[] getShardFailures() {
        return this.shardFailures;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
        out.writeVInt(this.skippedShards);
        out.writeLong(this.creationTime);
        out.writeVInt(this.shardFailures.length);
        for (ShardSearchFailure shardSearchFailure : this.shardFailures) {
            shardSearchFailure.writeTo(out);
        }
    }

    public String getId() {
        return this.id;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getSkippedShards() {
        return this.skippedShards;
    }

    @Override
    public RestStatus status() {
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures);
    }
}

