/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.pipeline.PipelineConfiguration;
import io.skylite.core.search.pipeline.SearchPipelineMetadata;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.StatusToXContentObject;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GetSearchPipelineResponse
extends ActionResponse
implements StatusToXContentObject {
    private final List<PipelineConfiguration> pipelines;

    public GetSearchPipelineResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.pipelines = new ArrayList<PipelineConfiguration>(size);
        for (int i = 0; i < size; ++i) {
            this.pipelines.add(SearchPipelineMetadata.readPipelineConfigurationFrom(in));
        }
    }

    public GetSearchPipelineResponse(List<PipelineConfiguration> pipelines) {
        this.pipelines = pipelines;
    }

    public List<PipelineConfiguration> pipelines() {
        return Collections.unmodifiableList(this.pipelines);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (PipelineConfiguration pipeline : this.pipelines) {
            builder.field(pipeline.getId(), pipeline.getConfigAsMap());
        }
        builder.endObject();
        return builder;
    }

    public static GetSearchPipelineResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        ArrayList<PipelineConfiguration> pipelines = new ArrayList<PipelineConfiguration>();
        while (parser.nextToken().equals((Object)XContentParser.Token.FIELD_NAME)) {
            String pipelineId = parser.currentName();
            parser.nextToken();
            XContentBuilder contentBuilder = XContentBuilder.builder(parser.contentType().xContent());
            try {
                contentBuilder.generator().copyCurrentStructure(parser);
                PipelineConfiguration pipeline = new PipelineConfiguration(pipelineId, BytesReference.bytes(contentBuilder), contentBuilder.contentType());
                pipelines.add(pipeline);
            }
            finally {
                if (contentBuilder == null) continue;
                contentBuilder.close();
            }
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.currentToken(), parser);
        return new GetSearchPipelineResponse(pipelines);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.pipelines.size());
        for (PipelineConfiguration pipeline : this.pipelines) {
            pipeline.writeTo(out);
        }
    }

    public boolean isFound() {
        return !this.pipelines.isEmpty();
    }

    @Override
    public RestStatus status() {
        return this.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSearchPipelineResponse otherResponse = (GetSearchPipelineResponse)o;
        if (this.pipelines == null) {
            return otherResponse.pipelines == null;
        }
        if (otherResponse.pipelines == null) {
            return false;
        }
        return GetSearchPipelineResponse.toMap(this.pipelines).equals(GetSearchPipelineResponse.toMap(otherResponse.pipelines));
    }

    private static Map<String, PipelineConfiguration> toMap(List<PipelineConfiguration> pipelines) {
        return pipelines.stream().collect(Collectors.toMap(PipelineConfiguration::getId, p -> p));
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public int hashCode() {
        int result = 1;
        for (PipelineConfiguration pipeline : this.pipelines) {
            result += pipeline == null ? 0 : pipeline.hashCode();
        }
        return result;
    }
}

