/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.clustermanager.AcknowledgedRequest;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public class PutSearchPipelineRequest
extends AcknowledgedRequest<PutSearchPipelineRequest>
implements ToXContentObject {
    private String id;
    private BytesReference source;
    private MediaType mediaType;

    public PutSearchPipelineRequest(String id, BytesReference source, MediaType mediaType) {
        this.id = Objects.requireNonNull(id);
        this.source = Objects.requireNonNull(source);
        this.mediaType = Objects.requireNonNull(mediaType);
    }

    public PutSearchPipelineRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
        this.mediaType = in.readMediaType();
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
        this.mediaType.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source != null) {
            builder.rawValue(this.source.streamInput(), this.mediaType);
        } else {
            builder.startObject().endObject();
        }
        return builder;
    }
}

