/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.Nullable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.search.internal.ShardSearchContextId;
import java.io.IOException;

public final class SearchContextIdForNode
implements Writeable {
    private final String node;
    private final ShardSearchContextId searchContextId;
    private final String clusterAlias;

    public SearchContextIdForNode(@Nullable String clusterAlias, String node, ShardSearchContextId searchContextId) {
        this.node = node;
        this.clusterAlias = clusterAlias;
        this.searchContextId = searchContextId;
    }

    public SearchContextIdForNode(StreamInput in) throws IOException {
        this.node = in.readString();
        this.clusterAlias = in.readOptionalString();
        this.searchContextId = new ShardSearchContextId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.node);
        out.writeOptionalString(this.clusterAlias);
        this.searchContextId.writeTo(out);
    }

    public String getNode() {
        return this.node;
    }

    @Nullable
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public ShardSearchContextId getSearchContextId() {
        return this.searchContextId;
    }

    public String toString() {
        return "SearchContextIdForNode{node='" + this.node + "', seachContextId=" + String.valueOf(this.searchContextId) + ", clusterAlias='" + this.clusterAlias + "'}";
    }
}

