/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.search.AbstractSearchAsyncAction;
import io.skylite.core.action.search.SearchActionListener;
import io.skylite.core.action.search.SearchPhase;
import io.skylite.core.action.search.SearchPhaseContext;
import io.skylite.core.action.search.SearchPhaseName;
import io.skylite.core.action.search.SearchProgressListener;
import io.skylite.core.action.search.SearchQueryThenFetchAsyncAction;
import io.skylite.core.action.search.SearchRequestOperationsListener;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchShardIterator;
import io.skylite.core.action.search.SearchTask;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.TransportSearchAction;
import io.skylite.core.action.search.phase.ArraySearchPhaseResults;
import io.skylite.core.action.search.phase.DfsQueryPhase;
import io.skylite.core.action.search.phase.FetchSearchPhase;
import io.skylite.core.action.search.phase.QueryPhaseResultConsumer;
import io.skylite.core.action.search.phase.SearchPhaseController;
import io.skylite.core.action.search.phase.SearchPhaseResults;
import io.skylite.core.cluster.routing.GroupShardsIterator;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.dfs.AggregatedDfs;
import io.skylite.core.search.dfs.DfsSearchResult;
import io.skylite.core.search.internal.AliasFilter;
import io.skylite.core.transport.TransportConnection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;

final class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    private final SearchPhaseController searchPhaseController;
    private final QueryPhaseResultConsumer queryPhaseResultConsumer;

    SearchDfsQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, TransportConnection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, SearchPhaseController searchPhaseController, Executor executor, QueryPhaseResultConsumer queryPhaseResultConsumer, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, SearchResponse.Clusters clusters, SearchRequestOperationsListener searchRequestOperationsListener) {
        super(SearchPhaseName.DFS_PRE_QUERY.getName(), logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterState, task, new ArraySearchPhaseResults(shardsIts.size()), request.getMaxConcurrentShardRequests(), clusters, searchRequestOperationsListener);
        this.queryPhaseResultConsumer = queryPhaseResultConsumer;
        this.searchPhaseController = searchPhaseController;
        SearchProgressListener progressListener = task.getProgressListener();
        SearchSourceBuilder sourceBuilder = request.source();
        progressListener.notifyListShards(SearchQueryThenFetchAsyncAction.buildSearchShards(this.shardsIts), SearchQueryThenFetchAsyncAction.buildSearchShards(this.toSkipShardsIts), clusters, sourceBuilder == null || sourceBuilder.size() != 0);
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<DfsSearchResult> listener) {
        this.getSearchTransport().sendExecuteDfs(this.getConnection(shard.getClusterAlias(), shard.getNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<DfsSearchResult> results, SearchPhaseContext context) {
        List<DfsSearchResult> dfsSearchResults = results.getAtomicArray().asList();
        AggregatedDfs aggregatedDfs = this.searchPhaseController.aggregateDfs(dfsSearchResults);
        return new DfsQueryPhase(dfsSearchResults, aggregatedDfs, this.queryPhaseResultConsumer, queryResults -> new FetchSearchPhase((SearchPhaseResults<SearchPhaseResult>)queryResults, this.searchPhaseController, aggregatedDfs, context), context);
    }
}

