/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.core.action.search.SearchQueryCounters;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.MatchPhraseQueryBuilder;
import io.skylite.core.index.query.MatchQueryBuilder;
import io.skylite.core.index.query.MultiMatchQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryBuilderVisitor;
import io.skylite.core.index.query.QueryStringQueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.index.query.RegexpQueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.index.query.WildcardQueryBuilder;
import io.skylite.core.index.query.functionscore.FunctionScoreQueryBuilder;
import io.skylite.core.telemetry.metrics.tags.Tags;
import org.apache.lucene.search.BooleanClause;

final class SearchQueryCategorizingVisitor
implements QueryBuilderVisitor {
    private static final String LEVEL_TAG = "level";
    private final int level;
    private final SearchQueryCounters searchQueryCounters;

    public SearchQueryCategorizingVisitor(SearchQueryCounters searchQueryCounters) {
        this(searchQueryCounters, 0);
    }

    private SearchQueryCategorizingVisitor(SearchQueryCounters counters, int level) {
        this.searchQueryCounters = counters;
        this.level = level;
    }

    @Override
    public void accept(QueryBuilder qb) {
        if (qb instanceof BoolQueryBuilder) {
            this.searchQueryCounters.boolCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        } else if (qb instanceof FunctionScoreQueryBuilder) {
            this.searchQueryCounters.functionScoreCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        } else if (qb instanceof MatchQueryBuilder) {
            this.searchQueryCounters.matchCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        } else if (qb instanceof MatchPhraseQueryBuilder) {
            this.searchQueryCounters.matchPhrasePrefixCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        } else if (qb instanceof MultiMatchQueryBuilder) {
            this.searchQueryCounters.multiMatchCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        } else if (qb instanceof QueryStringQueryBuilder) {
            this.searchQueryCounters.queryStringQueryCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        } else if (qb instanceof RangeQueryBuilder) {
            this.searchQueryCounters.rangeCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        } else if (qb instanceof RegexpQueryBuilder) {
            this.searchQueryCounters.regexCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        } else if (qb instanceof TermQueryBuilder) {
            this.searchQueryCounters.termCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        } else if (qb instanceof WildcardQueryBuilder) {
            this.searchQueryCounters.wildcardCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        } else {
            this.searchQueryCounters.otherQueryCounter.add(1.0, Tags.create().addTag(LEVEL_TAG, this.level));
        }
    }

    @Override
    public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
        return new SearchQueryCategorizingVisitor(this.searchQueryCounters, this.level + 1);
    }
}

