/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.core.ParseField;
import io.skylite.core.aggregations.Aggregations;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.SearchExtBuilder;
import io.skylite.core.search.SearchHits;
import io.skylite.core.search.profile.ProfileShardResult;
import io.skylite.core.search.profile.SearchProfileShardResults;
import io.skylite.core.search.suggest.Suggest;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SearchResponseSections
implements ToXContentFragment {
    public static final ParseField EXT_FIELD = new ParseField("ext", new String[0]);
    protected final SearchHits hits;
    protected final Aggregations aggregations;
    protected final Suggest suggest;
    protected final SearchProfileShardResults profileResults;
    protected final boolean timedOut;
    protected final Boolean terminatedEarly;
    protected final int numReducePhases;
    protected final List<SearchExtBuilder> searchExtBuilders = new ArrayList<SearchExtBuilder>();

    public SearchResponseSections(SearchHits hits, Aggregations aggregations, Suggest suggest, boolean timedOut, Boolean terminatedEarly, SearchProfileShardResults profileResults, int numReducePhases) {
        this(hits, aggregations, suggest, timedOut, terminatedEarly, profileResults, numReducePhases, Collections.emptyList());
    }

    public SearchResponseSections(SearchHits hits, Aggregations aggregations, Suggest suggest, boolean timedOut, Boolean terminatedEarly, SearchProfileShardResults profileResults, int numReducePhases, List<SearchExtBuilder> searchExtBuilders) {
        this.hits = hits;
        this.aggregations = aggregations;
        this.suggest = suggest;
        this.profileResults = profileResults;
        this.timedOut = timedOut;
        this.terminatedEarly = terminatedEarly;
        this.numReducePhases = numReducePhases;
        this.searchExtBuilders.addAll((Collection<SearchExtBuilder>)Objects.requireNonNull(searchExtBuilders, "searchExtBuilders must not be null"));
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public final SearchHits hits() {
        return this.hits;
    }

    public final Aggregations aggregations() {
        return this.aggregations;
    }

    public final Suggest suggest() {
        return this.suggest;
    }

    public final int getNumReducePhases() {
        return this.numReducePhases;
    }

    public final Map<String, ProfileShardResult> profile() {
        if (this.profileResults == null) {
            return Collections.emptyMap();
        }
        return this.profileResults.getShardResults();
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.hits.toXContent(builder, params);
        if (this.aggregations != null) {
            this.aggregations.toXContent(builder, params);
        }
        if (this.suggest != null) {
            this.suggest.toXContent(builder, params);
        }
        if (this.profileResults != null) {
            this.profileResults.toXContent(builder, params);
        }
        if (!this.searchExtBuilders.isEmpty()) {
            builder.startObject(EXT_FIELD.getPreferredName());
            for (SearchExtBuilder searchExtBuilder : this.searchExtBuilders) {
                searchExtBuilder.toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder;
    }

    public List<SearchExtBuilder> getSearchExtBuilders() {
        return Collections.unmodifiableList(this.searchExtBuilders);
    }

    protected void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

