/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.search.CreatePitAction;
import io.skylite.core.action.search.CreatePitController;
import io.skylite.core.action.search.CreatePitRequest;
import io.skylite.core.action.search.CreatePitResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.TransportSearchAction;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.util.Arrays;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class TransportCreatePitAction
extends HandledTransportAction<CreatePitRequest, CreatePitResponse> {
    public static final String CREATE_PIT_ACTION = "create_pit";
    private final TransportService transportService;
    private final SearchTransportService searchTransportService;
    private final ClusterService clusterService;
    private final TransportSearchAction transportSearchAction;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final CreatePitController createPitController;

    @Inject
    public TransportCreatePitAction(TransportService transportService, ActionFilters actionFilters, SearchTransportService searchTransportService, ClusterService clusterService, TransportSearchAction transportSearchAction, NamedWriteableRegistry namedWriteableRegistry, CreatePitController createPitController) {
        super("indices:data/read/point_in_time/create", transportService, actionFilters, in -> new CreatePitRequest(in));
        this.transportService = transportService;
        this.searchTransportService = searchTransportService;
        this.clusterService = clusterService;
        this.transportSearchAction = transportSearchAction;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.createPitController = createPitController;
    }

    @Override
    protected void doExecute(Task task, CreatePitRequest request, ActionListener<CreatePitResponse> listener) {
        StepListener<SearchResponse> createPitListener = new StepListener<SearchResponse>();
        ActionListener updatePitIdListener = ActionListenerHelper.wrap(r -> listener.onResponse(r), e -> {
            this.logger.error(() -> new ParameterizedMessage("PIT creation failed while updating PIT ID for indices [{}]", (Object)Arrays.toString(request.indices())));
            listener.onFailure(e);
        });
        this.createPitController.executeCreatePit(request, task, createPitListener, updatePitIdListener);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        @Override
        public ActionType<? extends ActionResponse> getInstance() {
            return CreatePitAction.INSTANCE;
        }

        @Override
        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportCreatePitAction.class;
        }
    }
}

