/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.Version;
import io.skylite.core.action.search.ParsedScrollId;
import io.skylite.core.action.search.SearchContextIdForNode;
import io.skylite.core.action.search.SearchScrollRequest;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.common.io.stream.BytesStreamInput;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.internal.InternalScrollSearchRequest;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.transport.RemoteClusterUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;

public final class TransportSearchHelper {
    private static final String INCLUDE_CONTEXT_UUID = "include_context_uuid";

    public static InternalScrollSearchRequest internalScrollSearchRequest(ShardSearchContextId id, SearchScrollRequest request) {
        return new InternalScrollSearchRequest(request, id);
    }

    public static String buildScrollId(AtomicArray<? extends SearchPhaseResult> searchPhaseResults, Version<?> version) {
        try {
            BytesStreamOutput out = new BytesStreamOutput();
            out.writeString(INCLUDE_CONTEXT_UUID);
            out.writeString(searchPhaseResults.length() == 1 ? "queryAndFetch" : "queryThenFetch");
            out.writeVInt(searchPhaseResults.asList().size());
            for (SearchPhaseResult searchPhaseResult : searchPhaseResults.asList()) {
                out.writeString(searchPhaseResult.getContextId().getSessionId());
                out.writeLong(searchPhaseResult.getContextId().getId());
                SearchShardTarget searchShardTarget = searchPhaseResult.getSearchShardTarget();
                if (searchShardTarget.getClusterAlias() != null) {
                    out.writeString(RemoteClusterUtils.buildRemoteIndexName(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId()));
                    continue;
                }
                out.writeString(searchShardTarget.getNodeId());
            }
            byte[] bytes = BytesReference.toBytes(out.bytes());
            return Base64.getUrlEncoder().encodeToString(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TransportSearchHelper() {
    }

    public static ParsedScrollId parseScrollId(String scrollId) {
        try {
            String type;
            boolean includeContextUUID;
            byte[] bytes = Base64.getUrlDecoder().decode(scrollId);
            BytesStreamInput in = new BytesStreamInput(bytes);
            String firstChunk = in.readString();
            if (INCLUDE_CONTEXT_UUID.equals(firstChunk)) {
                includeContextUUID = true;
                type = in.readString();
            } else {
                includeContextUUID = false;
                type = firstChunk;
            }
            SearchContextIdForNode[] context = new SearchContextIdForNode[in.readVInt()];
            for (int i = 0; i < context.length; ++i) {
                String clusterAlias;
                String contextUUID = includeContextUUID ? in.readString() : "";
                long id = in.readLong();
                String target = in.readString();
                int index = target.indexOf(58);
                if (index == -1) {
                    clusterAlias = null;
                } else {
                    clusterAlias = target.substring(0, index);
                    target = target.substring(index + 1);
                }
                context[i] = new SearchContextIdForNode(clusterAlias, target, new ShardSearchContextId(contextUUID, id));
            }
            if (in.getPosition() != bytes.length) {
                throw new IllegalArgumentException("Not all bytes were read");
            }
            return new ParsedScrollId(scrollId, type, context);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse scroll id", e);
        }
    }
}

