/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search.phase;

import io.skylite.core.action.search.phase.SearchPhaseResults;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.search.SearchPhaseResult;
import java.util.stream.Stream;

public class ArraySearchPhaseResults<Result extends SearchPhaseResult>
extends SearchPhaseResults<Result> {
    final AtomicArray<Result> results;

    public ArraySearchPhaseResults(int size) {
        super(size);
        this.results = new AtomicArray(size);
    }

    @Override
    public Stream<Result> getSuccessfulResults() {
        return this.results.asList().stream();
    }

    @Override
    public void consumeResult(Result result, Runnable next) {
        assert (this.results.get(((SearchPhaseResult)result).getShardIndex()) == null) : "shardIndex: " + ((SearchPhaseResult)result).getShardIndex() + " is already set";
        this.results.set(((SearchPhaseResult)result).getShardIndex(), result);
        next.run();
    }

    @Override
    public boolean hasResult(int shardIndex) {
        return this.results.get(shardIndex) != null;
    }

    @Override
    public AtomicArray<Result> getAtomicArray() {
        return this.results;
    }
}

