/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search.phase;

import io.skylite.common.Nullable;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.core.action.search.SearchPhaseContext;
import io.skylite.core.action.search.phase.ArraySearchPhaseResults;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchShardTarget;

public final class CountedCollector<R extends SearchPhaseResult> {
    private final ArraySearchPhaseResults<R> resultConsumer;
    private final CountDown counter;
    private final Runnable onFinish;
    private final SearchPhaseContext context;

    public CountedCollector(ArraySearchPhaseResults<R> resultConsumer, int expectedOps, Runnable onFinish, SearchPhaseContext context) {
        this.resultConsumer = resultConsumer;
        this.counter = new CountDown(expectedOps);
        this.onFinish = onFinish;
        this.context = context;
    }

    public void countDown() {
        assert (!this.counter.isCountedDown()) : "more operations executed than specified";
        if (this.counter.countDown()) {
            this.onFinish.run();
        }
    }

    public void onResult(R result) {
        this.resultConsumer.consumeResult(result, this::countDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Exception e) {
        try {
            this.context.onShardFailure(shardIndex, shardTarget, e);
        }
        finally {
            this.countDown();
        }
    }
}

