/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search.phase;

import io.skylite.core.action.search.SearchActionListener;
import io.skylite.core.action.search.SearchPhase;
import io.skylite.core.action.search.SearchPhaseContext;
import io.skylite.core.action.search.SearchPhaseName;
import io.skylite.core.action.search.SearchProgressListener;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.phase.ArraySearchPhaseResults;
import io.skylite.core.action.search.phase.CountedCollector;
import io.skylite.core.action.search.phase.QueryPhaseResultConsumer;
import io.skylite.core.action.search.query.QuerySearchRequest;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.dfs.AggregatedDfs;
import io.skylite.core.search.dfs.DfsSearchResult;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.transport.TransportConnection;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.message.ParameterizedMessage;

public final class DfsQueryPhase
extends SearchPhase {
    private final ArraySearchPhaseResults<SearchPhaseResult> queryResult;
    private final List<DfsSearchResult> searchResults;
    private final AggregatedDfs dfs;
    private final Function<ArraySearchPhaseResults<SearchPhaseResult>, SearchPhase> nextPhaseFactory;
    private final SearchPhaseContext context;
    private final SearchTransportService searchTransportService;
    private final SearchProgressListener progressListener;

    public DfsQueryPhase(List<DfsSearchResult> searchResults, AggregatedDfs dfs, QueryPhaseResultConsumer queryResult, Function<ArraySearchPhaseResults<SearchPhaseResult>, SearchPhase> nextPhaseFactory, SearchPhaseContext context) {
        super(SearchPhaseName.DFS_QUERY.getName());
        this.progressListener = context.getTask().getProgressListener();
        this.queryResult = queryResult;
        this.searchResults = searchResults;
        this.dfs = dfs;
        this.nextPhaseFactory = nextPhaseFactory;
        this.context = context;
        this.searchTransportService = context.getSearchTransport();
        context.addReleasable(queryResult);
    }

    public void run() throws IOException {
        final CountedCollector<SearchPhaseResult> counter = new CountedCollector<SearchPhaseResult>(this.queryResult, this.searchResults.size(), () -> this.context.executeNextPhase(this, this.nextPhaseFactory.apply(this.queryResult)), this.context);
        for (DfsSearchResult dfsResult : this.searchResults) {
            final SearchShardTarget searchShardTarget = dfsResult.getSearchShardTarget();
            final TransportConnection connection = this.context.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
            final QuerySearchRequest querySearchRequest = new QuerySearchRequest(searchShardTarget.getOriginalIndices(), dfsResult.getContextId(), dfsResult.getShardSearchRequest(), this.dfs);
            final int shardIndex = dfsResult.getShardIndex();
            this.searchTransportService.sendExecuteQuery(connection, querySearchRequest, this.context.getTask(), new SearchActionListener<QuerySearchResult>(searchShardTarget, shardIndex){

                @Override
                protected void innerOnResponse(QuerySearchResult response) {
                    try {
                        counter.onResult(response);
                    }
                    catch (Exception e) {
                        DfsQueryPhase.this.context.onPhaseFailure(DfsQueryPhase.this, "", e);
                    }
                }

                public void onFailure(Exception exception) {
                    try {
                        DfsQueryPhase.this.context.getLogger().debug(() -> new ParameterizedMessage("[{}] Failed to execute query phase", (Object)querySearchRequest.contextId()), (Throwable)exception);
                        DfsQueryPhase.this.progressListener.notifyQueryFailure(shardIndex, searchShardTarget, exception);
                        counter.onFailure(shardIndex, searchShardTarget, exception);
                    }
                    finally {
                        if (DfsQueryPhase.this.context.getRequest().pointInTimeBuilder() == null) {
                            DfsQueryPhase.this.context.sendReleaseSearchContext(querySearchRequest.contextId(), connection, searchShardTarget.getOriginalIndices());
                        }
                    }
                }
            });
        }
    }
}

