/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search.phase;

import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.search.SearchActionListener;
import io.skylite.core.action.search.SearchPhase;
import io.skylite.core.action.search.SearchPhaseContext;
import io.skylite.core.action.search.SearchPhaseName;
import io.skylite.core.action.search.SearchProgressListener;
import io.skylite.core.action.search.phase.ArraySearchPhaseResults;
import io.skylite.core.action.search.phase.CountedCollector;
import io.skylite.core.action.search.phase.ExpandSearchPhase;
import io.skylite.core.action.search.phase.SearchPhaseController;
import io.skylite.core.action.search.phase.SearchPhaseResults;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.search.RescoreDocIds;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.dfs.AggregatedDfs;
import io.skylite.core.search.fetch.FetchSearchResult;
import io.skylite.core.search.fetch.ShardFetchSearchRequest;
import io.skylite.core.search.internal.InternalSearchResponse;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.transport.TransportConnection;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.ScoreDoc;

public final class FetchSearchPhase
extends SearchPhase {
    private final ArraySearchPhaseResults<FetchSearchResult> fetchResults;
    private final SearchPhaseController searchPhaseController;
    private final AtomicArray<SearchPhaseResult> queryResults;
    private final BiFunction<InternalSearchResponse, AtomicArray<SearchPhaseResult>, SearchPhase> nextPhaseFactory;
    private final SearchPhaseContext context;
    private final Logger logger;
    private final SearchPhaseResults<SearchPhaseResult> resultConsumer;
    private final SearchProgressListener progressListener;
    private final AggregatedDfs aggregatedDfs;

    public FetchSearchPhase(SearchPhaseResults<SearchPhaseResult> resultConsumer, SearchPhaseController searchPhaseController, AggregatedDfs aggregatedDfs, SearchPhaseContext context) {
        this(resultConsumer, searchPhaseController, aggregatedDfs, context, (response, queryPhaseResults) -> new ExpandSearchPhase(context, (InternalSearchResponse)response, (AtomicArray<SearchPhaseResult>)queryPhaseResults));
    }

    public FetchSearchPhase(SearchPhaseResults<SearchPhaseResult> resultConsumer, SearchPhaseController searchPhaseController, AggregatedDfs aggregatedDfs, SearchPhaseContext context, BiFunction<InternalSearchResponse, AtomicArray<SearchPhaseResult>, SearchPhase> nextPhaseFactory) {
        super(SearchPhaseName.FETCH.getName());
        if (context.getNumShards() != resultConsumer.getNumShards()) {
            throw new IllegalStateException("number of shards must match the length of the query results but doesn't:" + context.getNumShards() + "!=" + resultConsumer.getNumShards());
        }
        this.fetchResults = new ArraySearchPhaseResults(resultConsumer.getNumShards());
        this.searchPhaseController = searchPhaseController;
        this.queryResults = resultConsumer.getAtomicArray();
        this.aggregatedDfs = aggregatedDfs;
        this.nextPhaseFactory = nextPhaseFactory;
        this.context = context;
        this.logger = context.getLogger();
        this.resultConsumer = resultConsumer;
        this.progressListener = context.getTask().getProgressListener();
    }

    public void run() {
        this.context.execute((Runnable)new AbstractRunnable(){

            public void doRun() throws Exception {
                FetchSearchPhase.this.innerRun();
            }

            public void onFailure(Exception e) {
                FetchSearchPhase.this.context.onPhaseFailure(FetchSearchPhase.this, "", e);
            }
        });
    }

    private void innerRun() throws Exception {
        int numShards = this.context.getNumShards();
        boolean isScrollSearch = this.context.getRequest().scroll() != null;
        List<SearchPhaseResult> phaseResults = this.queryResults.asList();
        SearchPhaseController.ReducedQueryPhase reducedQueryPhase = this.resultConsumer.reduce();
        boolean queryAndFetchOptimization = this.queryResults.length() == 1;
        Runnable finishPhase = () -> this.moveToNextPhase(this.searchPhaseController, this.queryResults, reducedQueryPhase, queryAndFetchOptimization ? this.queryResults : this.fetchResults.getAtomicArray());
        if (queryAndFetchOptimization) {
            assert (phaseResults.isEmpty() || phaseResults.get(0).fetchResult() != null) : "phaseResults empty [" + phaseResults.isEmpty() + "], single result: " + String.valueOf(phaseResults.get(0).fetchResult());
            finishPhase.run();
        } else {
            ScoreDoc[] scoreDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
            List<Integer>[] docIdsToLoad = this.searchPhaseController.fillDocIdsToLoad(numShards, scoreDocs);
            if (scoreDocs.length == 0) {
                phaseResults.stream().map(SearchPhaseResult::queryResult).forEach(this::releaseIrrelevantSearchContext);
                finishPhase.run();
            } else {
                ScoreDoc[] lastEmittedDocPerShard = isScrollSearch ? this.searchPhaseController.getLastEmittedDocPerShard(reducedQueryPhase, numShards) : null;
                CountedCollector<FetchSearchResult> counter = new CountedCollector<FetchSearchResult>(this.fetchResults, docIdsToLoad.length, finishPhase, this.context);
                for (int i = 0; i < docIdsToLoad.length; ++i) {
                    List<Integer> entry = docIdsToLoad[i];
                    SearchPhaseResult queryResult = this.queryResults.get(i);
                    if (entry == null) {
                        if (queryResult != null) {
                            this.releaseIrrelevantSearchContext(queryResult.queryResult());
                            this.progressListener.notifyFetchResult(i);
                        }
                        counter.countDown();
                        continue;
                    }
                    SearchShardTarget searchShardTarget = queryResult.getSearchShardTarget();
                    TransportConnection connection = this.context.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                    ShardFetchSearchRequest fetchSearchRequest = this.createFetchRequest(queryResult.queryResult().getContextId(), i, entry, lastEmittedDocPerShard, searchShardTarget.getOriginalIndices(), queryResult.getShardSearchRequest(), queryResult.getRescoreDocIds());
                    this.executeFetch(i, searchShardTarget, counter, fetchSearchRequest, queryResult.queryResult(), connection);
                }
            }
        }
    }

    protected ShardFetchSearchRequest createFetchRequest(ShardSearchContextId contextId, int index, List<Integer> entry, ScoreDoc[] lastEmittedDocPerShard, OriginalIndices originalIndices, ShardSearchRequest shardSearchRequest, RescoreDocIds rescoreDocIds) {
        ScoreDoc lastEmittedDoc = lastEmittedDocPerShard != null ? lastEmittedDocPerShard[index] : null;
        return new ShardFetchSearchRequest(originalIndices, contextId, shardSearchRequest, entry, lastEmittedDoc, rescoreDocIds, this.aggregatedDfs);
    }

    private void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final CountedCollector<FetchSearchResult> counter, final ShardFetchSearchRequest fetchSearchRequest, final QuerySearchResult querySearchResult, TransportConnection connection) {
        this.context.getSearchTransport().sendExecuteFetch(connection, fetchSearchRequest, this.context.getTask(), new SearchActionListener<FetchSearchResult>(shardTarget, shardIndex){

            @Override
            public void innerOnResponse(FetchSearchResult result) {
                try {
                    FetchSearchPhase.this.progressListener.notifyFetchResult(shardIndex);
                    counter.onResult(result);
                }
                catch (Exception e) {
                    FetchSearchPhase.this.context.onPhaseFailure(FetchSearchPhase.this, "", e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    FetchSearchPhase.this.logger.debug(() -> new ParameterizedMessage("[{}] Failed to execute fetch phase", (Object)fetchSearchRequest.contextId()), (Throwable)e);
                    FetchSearchPhase.this.progressListener.notifyFetchFailure(shardIndex, shardTarget, e);
                    counter.onFailure(shardIndex, shardTarget, e);
                }
                finally {
                    FetchSearchPhase.this.releaseIrrelevantSearchContext(querySearchResult);
                }
            }
        });
    }

    private void releaseIrrelevantSearchContext(QuerySearchResult queryResult) {
        if (queryResult.hasSearchContext() && this.context.getRequest().scroll() == null && this.context.getRequest().pointInTimeBuilder() == null) {
            try {
                SearchShardTarget searchShardTarget = queryResult.getSearchShardTarget();
                TransportConnection connection = this.context.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                this.context.sendReleaseSearchContext(queryResult.getContextId(), connection, searchShardTarget.getOriginalIndices());
            }
            catch (Exception e) {
                this.context.getLogger().trace("failed to release context", (Throwable)e);
            }
        }
    }

    private void moveToNextPhase(SearchPhaseController searchPhaseController, AtomicArray<SearchPhaseResult> queryPhaseResults, SearchPhaseController.ReducedQueryPhase reducedQueryPhase, AtomicArray<? extends SearchPhaseResult> fetchResultsArr) {
        InternalSearchResponse internalResponse = searchPhaseController.merge(this.context.getRequest().scroll() != null, reducedQueryPhase, fetchResultsArr.asList(), fetchResultsArr::get);
        this.context.executeNextPhase(this, this.nextPhaseFactory.apply(internalResponse, queryPhaseResults));
    }
}

