/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search.query;

import io.skylite.common.Nullable;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.search.SearchShardTask;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.dfs.AggregatedDfs;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;
import java.util.Map;

public class QuerySearchRequest
extends TransportRequest
implements IndicesRequest {
    private final ShardSearchContextId contextId;
    private final AggregatedDfs dfs;
    private final OriginalIndices originalIndices;
    private final ShardSearchRequest shardSearchRequest;

    public QuerySearchRequest(OriginalIndices originalIndices, ShardSearchContextId contextId, ShardSearchRequest shardSearchRequest, AggregatedDfs dfs) {
        this.contextId = contextId;
        this.dfs = dfs;
        this.shardSearchRequest = shardSearchRequest;
        this.originalIndices = originalIndices;
    }

    public QuerySearchRequest(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        this.dfs = new AggregatedDfs(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        this.shardSearchRequest = in.readOptionalWriteable(ShardSearchRequest::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.contextId.writeTo(out);
        this.dfs.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        out.writeOptionalWriteable(this.shardSearchRequest);
    }

    public ShardSearchContextId contextId() {
        return this.contextId;
    }

    public AggregatedDfs dfs() {
        return this.dfs;
    }

    @Nullable
    public ShardSearchRequest shardSearchRequest() {
        return this.shardSearchRequest;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers, this::getMetadataSupplier);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("id[");
        sb.append(this.contextId);
        sb.append("], ");
        sb.append("indices[");
        Strings.arrayToDelimitedString(this.originalIndices.indices(), ",", sb);
        sb.append("]");
        return sb.toString();
    }

    public String getMetadataSupplier() {
        return this.shardSearchRequest().getMetadataSupplier();
    }
}

