/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;

public final class ActiveShardCount
implements Writeable {
    private static final int ACTIVE_SHARD_COUNT_DEFAULT = -2;
    private static final int ALL_ACTIVE_SHARDS = -1;
    public static final ActiveShardCount DEFAULT = new ActiveShardCount(-2);
    public static final ActiveShardCount ALL = new ActiveShardCount(-1);
    public static final ActiveShardCount NONE = new ActiveShardCount(0);
    public static final ActiveShardCount ONE = new ActiveShardCount(1);
    private final int value;

    private ActiveShardCount(int value) {
        this.value = value;
    }

    public static ActiveShardCount from(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("shard count cannot be a negative value");
        }
        return ActiveShardCount.get(value);
    }

    public boolean validate(int numberOfReplicas) {
        assert (numberOfReplicas >= 0);
        return this.value <= numberOfReplicas + 1;
    }

    public int getNumericValue() {
        return this.value;
    }

    private static ActiveShardCount get(int value) {
        switch (value) {
            case -2: {
                return DEFAULT;
            }
            case -1: {
                return ALL;
            }
            case 1: {
                return ONE;
            }
            case 0: {
                return NONE;
            }
        }
        assert (value > 1);
        return new ActiveShardCount(value);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.value);
    }

    public static ActiveShardCount readFrom(StreamInput in) throws IOException {
        return ActiveShardCount.get(in.readInt());
    }

    public static ActiveShardCount parseString(String str) {
        int val;
        if (str == null) {
            return DEFAULT;
        }
        if (str.equals("all")) {
            return ALL;
        }
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("cannot parse ActiveShardCount[" + str + "]", e);
        }
        return ActiveShardCount.from(val);
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveShardCount that = (ActiveShardCount)o;
        return this.value == that.value;
    }

    public String toString() {
        switch (this.value) {
            case -1: {
                return "ALL";
            }
            case -2: {
                return "DEFAULT";
            }
        }
        return Integer.toString(this.value);
    }
}

