/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.IndexRoutingTable;
import io.skylite.core.cluster.routing.IndexShardRoutingTable;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.node.NodeClosedException;
import io.skylite.core.threadpool.ThreadPool;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActiveShardsObserver {
    private static final Logger logger = LogManager.getLogger(ActiveShardsObserver.class);
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public ActiveShardsObserver(ClusterService clusterService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public void waitForActiveShards(final String[] indexNames, ActiveShardCount activeShardCount, TimeValue timeout, final Consumer<Boolean> onResult, final Consumer<Exception> onFailure) {
        if (activeShardCount == ActiveShardCount.NONE) {
            onResult.accept(true);
            return;
        }
        ClusterState state = this.clusterService.state();
        ClusterStateObserver observer = new ClusterStateObserver(state, this.clusterService, null, logger, this.threadPool.getThreadContext());
        if (ActiveShardsObserver.enoughShardsActive(activeShardCount, state, indexNames)) {
            onResult.accept(true);
        } else {
            Predicate<ClusterState> shardsAllocatedPredicate = newState -> ActiveShardsObserver.enoughShardsActive(activeShardCount, newState, indexNames);
            ClusterStateObserver.Listener observerListener = new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    onResult.accept(true);
                }

                @Override
                public void onClusterServiceClose() {
                    logger.debug("[{}] cluster service closed while waiting for enough shards to be started.", (Object)Arrays.toString(indexNames));
                    onFailure.accept(new NodeClosedException(ActiveShardsObserver.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    onResult.accept(false);
                }
            };
            observer.waitForNextChange(observerListener, shardsAllocatedPredicate, timeout);
        }
    }

    public static boolean enoughShardsActive(ActiveShardCount activeShardCountObj, int activeShardCount) {
        if (activeShardCountObj.getNumericValue() < 0) {
            throw new IllegalStateException("not enough information to resolve to shard count");
        }
        if (activeShardCount < 0) {
            throw new IllegalArgumentException("activeShardCount cannot be negative");
        }
        return activeShardCountObj.getNumericValue() <= activeShardCount;
    }

    public static boolean enoughShardsActive(ActiveShardCount activeShardCount, ClusterState clusterState, String ... indices) {
        if (activeShardCount == ActiveShardCount.NONE) {
            return true;
        }
        for (String indexName : indices) {
            IndexRoutingTable indexRoutingTable;
            IndexMetadata indexMetadata = clusterState.metadata().index(indexName);
            if (indexMetadata == null || (indexRoutingTable = clusterState.routingTable().index(indexName)) == null && indexMetadata.getState() == IndexMetadata.State.CLOSE) continue;
            assert (indexRoutingTable != null);
            if (!indexRoutingTable.allPrimaryShardsActive()) {
                return false;
            }
            ActiveShardCount waitForActiveShards = activeShardCount;
            if (waitForActiveShards == ActiveShardCount.DEFAULT) {
                waitForActiveShards = IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS.get(indexMetadata.getSettings());
            }
            for (IndexShardRoutingTable shardRouting : indexRoutingTable.getShards().values()) {
                if (ActiveShardsObserver.enoughShardsActive(waitForActiveShards, shardRouting)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean enoughShardsActive(ActiveShardCount activeShardCountObj, IndexShardRoutingTable shardRoutingTable) {
        int activeShardCount = shardRoutingTable.activeShards().size();
        if (activeShardCountObj == ActiveShardCount.ALL) {
            return activeShardCount == shardRoutingTable.replicaShards().size() + 1;
        }
        if (activeShardCountObj == ActiveShardCount.DEFAULT) {
            return activeShardCount >= 1;
        }
        return activeShardCount >= activeShardCountObj.getNumericValue();
    }
}

