/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.core.ParseField;
import io.skylite.core.action.ShardOperationFailedException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;

public class DefaultShardOperationFailedException
extends ShardOperationFailedException
implements Writeable {
    private static final String INDEX = "index";
    private static final String SHARD_ID = "shard";
    private static final String REASON = "reason";
    public static final ConstructingObjectParser<DefaultShardOperationFailedException, Void> PARSER = new ConstructingObjectParser("failures", true, arg -> new DefaultShardOperationFailedException((String)arg[0], (Integer)arg[1], (Throwable)arg[2]));

    protected static <T extends DefaultShardOperationFailedException> void declareFields(ConstructingObjectParser<T, Void> objectParser) {
        objectParser.declareString(ConstructingObjectParser.constructorArg(), new ParseField(INDEX, new String[0]));
        objectParser.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(SHARD_ID, new String[0]));
        objectParser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SkyliteException.fromXContent(p), new ParseField(REASON, new String[0]));
    }

    protected DefaultShardOperationFailedException() {
    }

    protected DefaultShardOperationFailedException(StreamInput in) throws IOException {
        DefaultShardOperationFailedException.readFrom(in, this);
    }

    public DefaultShardOperationFailedException(SkyliteException e) {
        super(e.getIndex() == null ? null : e.getIndex().getName(), e.getShardId() == null ? -1 : e.getShardId().getId(), SkyliteExceptionsHelper.detailedMessage(e), e.status(), e);
    }

    public DefaultShardOperationFailedException(String index, int shardId, Throwable cause) {
        super(index, shardId, SkyliteExceptionsHelper.detailedMessage(cause), SkyliteExceptionsHelper.status(cause), cause);
    }

    public static DefaultShardOperationFailedException readShardOperationFailed(StreamInput in) throws IOException {
        return new DefaultShardOperationFailedException(in);
    }

    public static void readFrom(StreamInput in, DefaultShardOperationFailedException f) throws IOException {
        f.index = in.readOptionalString();
        f.shardId = in.readVInt();
        f.cause = in.readException();
        f.status = RestStatus.readFrom(in);
        f.reason = SkyliteExceptionsHelper.detailedMessage(f.cause);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.index);
        out.writeVInt(this.shardId);
        out.writeException(this.cause);
        RestStatus.writeTo(out, this.status);
    }

    public String toString() {
        return "[" + this.index + "][" + this.shardId + "] failed, reason [" + this.reason() + "]";
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SHARD_ID, this.shardId());
        builder.field(INDEX, this.index());
        builder.field("status", this.status.name());
        if (this.reason != null) {
            builder.startObject(REASON);
            SkyliteException.generateThrowableXContent(builder, params, this.cause);
            builder.endObject();
        }
        return builder;
    }

    public static DefaultShardOperationFailedException fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        DefaultShardOperationFailedException.declareFields(PARSER);
    }
}

