/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support;

import io.skylite.SkyliteTimeoutException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class ListenerTimeouts {
    public static <Response> ActionListener<Response> wrapWithTimeout(ThreadPool threadPool, ActionListener<Response> listener, TimeValue timeout, String executor, String listenerName) {
        return ListenerTimeouts.wrapWithTimeout(threadPool, timeout, executor, listener, (ActionListener<Response> ignore) -> {
            String timeoutMessage = "[" + listenerName + "] timed out after [" + String.valueOf(timeout) + "]";
            listener.onFailure((Exception)new SkyliteTimeoutException(timeoutMessage, new Object[0]));
        });
    }

    public static <Response> ActionListener<Response> wrapWithTimeout(ThreadPool threadPool, TimeValue timeout, String executor, ActionListener<Response> listener, Consumer<ActionListener<Response>> onTimeout) {
        TimeoutableListener<Response> wrappedListener = new TimeoutableListener<Response>(listener, onTimeout);
        wrappedListener.cancellable = threadPool.schedule(wrappedListener, timeout, executor);
        return wrappedListener;
    }

    private static class TimeoutableListener<Response>
    implements ActionListener<Response>,
    Runnable {
        private final AtomicBoolean isDone = new AtomicBoolean(false);
        private final ActionListener<Response> delegate;
        private final Consumer<ActionListener<Response>> onTimeout;
        private volatile Scheduler.ScheduledCancellable cancellable;

        private TimeoutableListener(ActionListener<Response> delegate, Consumer<ActionListener<Response>> onTimeout) {
            this.delegate = delegate;
            this.onTimeout = onTimeout;
        }

        public void onResponse(Response response) {
            if (this.isDone.compareAndSet(false, true)) {
                this.cancellable.cancel();
                this.delegate.onResponse(response);
            }
        }

        public void onFailure(Exception e) {
            if (this.isDone.compareAndSet(false, true)) {
                this.cancellable.cancel();
                this.delegate.onFailure(e);
            }
        }

        @Override
        public void run() {
            if (this.isDone.compareAndSet(false, true)) {
                this.onTimeout.accept(this);
            }
        }
    }
}

