/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support.broadcast;

import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.action.support.broadcast.BroadcastRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;

public abstract class BroadcastShardRequest
extends TransportRequest
implements IndicesRequest {
    private ShardId shardId;
    protected OriginalIndices originalIndices;

    protected BroadcastShardRequest() {
    }

    public BroadcastShardRequest(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    protected BroadcastShardRequest(ShardId shardId, BroadcastRequest<? extends BroadcastRequest<?>> request) {
        this.shardId = shardId;
        this.originalIndices = new OriginalIndices(request);
    }

    protected BroadcastShardRequest(ShardId shardId, OriginalIndices originalIndices) {
        this.shardId = shardId;
        this.originalIndices = originalIndices;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }
}

