/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support.nodes;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public abstract class BaseNodesRequest<Request extends BaseNodesRequest<Request>>
extends ActionRequest {
    private String[] nodesIds;
    private DiscoveryNode[] concreteNodes;
    private final TimeValue DEFAULT_TIMEOUT_SECS = TimeValue.timeValueSeconds((long)30L);
    private TimeValue timeout;

    protected BaseNodesRequest(StreamInput in) throws IOException {
        super(in);
        this.nodesIds = in.readStringArray();
        this.concreteNodes = in.readOptionalArray(DiscoveryNode::new, DiscoveryNode[]::new);
        this.timeout = in.readOptionalTimeValue();
    }

    protected BaseNodesRequest(String ... nodesIds) {
        this.nodesIds = nodesIds;
    }

    protected BaseNodesRequest(DiscoveryNode ... concreteNodes) {
        this.nodesIds = null;
        this.concreteNodes = concreteNodes;
    }

    public final String[] nodesIds() {
        return this.nodesIds;
    }

    public final Request nodesIds(String ... nodesIds) {
        this.nodesIds = nodesIds;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final Request timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue((String)timeout, (TimeValue)this.DEFAULT_TIMEOUT_SECS, (String)(this.getClass().getSimpleName() + ".timeout"));
        return (Request)this;
    }

    public DiscoveryNode[] concreteNodes() {
        return this.concreteNodes;
    }

    public void setConcreteNodes(DiscoveryNode[] concreteNodes) {
        this.concreteNodes = concreteNodes;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.nodesIds);
        out.writeOptionalArray(this.concreteNodes);
        out.writeOptionalTimeValue(this.timeout);
    }
}

