/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support.replication;

import io.skylite.core.action.support.replication.PendingReplicationActions;
import io.skylite.core.cluster.routing.ShardRouting;
import java.util.Objects;

public class ReplicationProxyRequest<ReplicaRequest> {
    private final ShardRouting shardRouting;
    private final ShardRouting primaryRouting;
    private final long globalCheckpoint;
    private final long maxSeqNoOfUpdatesOrDeletes;
    private final PendingReplicationActions pendingReplicationActions;
    private final ReplicaRequest replicaRequest;
    private final long primaryTerm;

    private ReplicationProxyRequest(ShardRouting shardRouting, ShardRouting primaryRouting, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, PendingReplicationActions pendingReplicationActions, ReplicaRequest replicaRequest, long primaryTerm) {
        this.shardRouting = Objects.requireNonNull(shardRouting);
        this.primaryRouting = Objects.requireNonNull(primaryRouting);
        this.globalCheckpoint = globalCheckpoint;
        this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
        this.pendingReplicationActions = Objects.requireNonNull(pendingReplicationActions);
        this.replicaRequest = Objects.requireNonNull(replicaRequest);
        this.primaryTerm = primaryTerm;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public ShardRouting getPrimaryRouting() {
        return this.primaryRouting;
    }

    public long getGlobalCheckpoint() {
        return this.globalCheckpoint;
    }

    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.maxSeqNoOfUpdatesOrDeletes;
    }

    public PendingReplicationActions getPendingReplicationActions() {
        return this.pendingReplicationActions;
    }

    public ReplicaRequest getReplicaRequest() {
        return this.replicaRequest;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public static class Builder<ReplicaRequest> {
        private final ShardRouting shardRouting;
        private final ShardRouting primaryRouting;
        private final long globalCheckpoint;
        private final long maxSeqNoOfUpdatesOrDeletes;
        private final PendingReplicationActions pendingReplicationActions;
        private final ReplicaRequest replicaRequest;
        private final long primaryTerm;

        public Builder(ShardRouting shardRouting, ShardRouting primaryRouting, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, PendingReplicationActions pendingReplicationActions, ReplicaRequest replicaRequest, long primaryTerm) {
            this.shardRouting = shardRouting;
            this.primaryRouting = primaryRouting;
            this.globalCheckpoint = globalCheckpoint;
            this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
            this.pendingReplicationActions = pendingReplicationActions;
            this.replicaRequest = replicaRequest;
            this.primaryTerm = primaryTerm;
        }

        public ReplicationProxyRequest<ReplicaRequest> build() {
            return new ReplicationProxyRequest<ReplicaRequest>(this.shardRouting, this.primaryRouting, this.globalCheckpoint, this.maxSeqNoOfUpdatesOrDeletes, this.pendingReplicationActions, this.replicaRequest, this.primaryTerm);
        }
    }
}

