/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support.replication;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.lease.Releasable;
import io.skylite.common.telemetry.tracing.Span;
import io.skylite.common.telemetry.tracing.SpanScope;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.TransportActions;
import io.skylite.core.action.support.WriteResponse;
import io.skylite.core.action.support.replication.ReplicatedWriteRequest;
import io.skylite.core.action.support.replication.ReplicationOperation;
import io.skylite.core.action.support.replication.ReplicationRequest;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.pressure.IndexingPressureService;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.PrimaryShardClosedException;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.translog.TranslogLocation;
import io.skylite.core.index.translog.TranslogSettings;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.settings.Settings;
import io.skylite.core.telemetry.tracing.SpanBuilder;
import io.skylite.core.telemetry.tracing.listener.TraceableActionListener;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public abstract class TransportWriteAction<Request extends ReplicatedWriteRequest<Request>, ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>, Response extends ReplicationResponse>
extends TransportReplicationAction<Request, ReplicaRequest, Response> {
    protected final IndexingPressureService indexingPressureService;
    protected final SystemIndices systemIndices;
    private final Function<BaseIndexShard, String> executorFunction;
    private final Tracer tracer;

    protected TransportWriteAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, TransportReplicationAction.IndexServiceProvider indexServiceProvider, ThreadPool threadPool, TransportReplicationAction.RemoteShardFailedAction remoteShardFailedAction, ActionFilters actionFilters, Writeable.Reader<Request> request, Writeable.Reader<ReplicaRequest> replicaRequest, Function<BaseIndexShard, String> executorFunction, boolean forceExecutionOnPrimary, IndexingPressureService indexingPressureService, SystemIndices systemIndices, Tracer tracer) {
        super(settings, actionName, transportService, clusterService, indexServiceProvider, threadPool, remoteShardFailedAction, actionFilters, request, replicaRequest, "same", true, forceExecutionOnPrimary);
        this.executorFunction = executorFunction;
        this.indexingPressureService = indexingPressureService;
        this.systemIndices = systemIndices;
        this.tracer = tracer;
    }

    protected String executor(BaseIndexShard shard) {
        return this.executorFunction.apply(shard);
    }

    @Override
    protected Releasable checkOperationLimits(Request request) {
        return this.indexingPressureService.markPrimaryOperationStarted(((ReplicationRequest)request).shardId(), this.primaryOperationSize(request), this.force((ReplicatedWriteRequest<?>)request));
    }

    protected boolean force(ReplicatedWriteRequest<?> request) {
        return this.forceExecutionOnPrimary || this.isSystemShard(request.shardId());
    }

    protected boolean isSystemShard(ShardId shardId) {
        IndexAbstraction abstraction = (IndexAbstraction)this.clusterService.state().metadata().getIndicesLookup().get(shardId.getIndexName());
        return abstraction != null ? abstraction.isSystem() : this.systemIndices.isSystemIndex(shardId.getIndexName());
    }

    @Override
    protected Releasable checkPrimaryLimits(Request request, boolean rerouteWasLocal, boolean localRerouteInitiatedByNodeClient) {
        if (rerouteWasLocal) {
            if (localRerouteInitiatedByNodeClient) {
                return this.indexingPressureService.markPrimaryOperationLocalToCoordinatingNodeStarted(((ReplicationRequest)request).shardId(), this.primaryOperationSize(request));
            }
            return () -> {};
        }
        return this.indexingPressureService.markPrimaryOperationStarted(((ReplicationRequest)request).shardId(), this.primaryOperationSize(request), this.force((ReplicatedWriteRequest<?>)request));
    }

    protected long primaryOperationSize(Request request) {
        return 0L;
    }

    @Override
    protected Releasable checkReplicaLimits(ReplicaRequest request) {
        return this.indexingPressureService.markReplicaOperationStarted(((ReplicationRequest)request).shardId(), this.replicaOperationSize(request), this.force((ReplicatedWriteRequest<?>)request));
    }

    protected long replicaOperationSize(ReplicaRequest request) {
        return 0L;
    }

    protected static TranslogLocation syncOperationResultOrThrow(EngineResult operationResult, TranslogLocation currentLocation) throws Exception {
        if (operationResult.getFailure() != null) {
            Exception failure = operationResult.getFailure();
            assert (failure instanceof MapperParsingException) : "expected mapper parsing failures. got " + String.valueOf(failure);
            throw failure;
        }
        TranslogLocation location = TransportWriteAction.locationToSync(currentLocation, operationResult.getTranslogLocation());
        return location;
    }

    public static TranslogLocation locationToSync(TranslogLocation current, TranslogLocation next) {
        assert (next != null) : "next operation can't be null";
        assert (current == null || current.compareTo(next) < 0) : "translog locations are not increasing";
        return next;
    }

    @Override
    public ReplicationOperation.Replicas<ReplicaRequest> newReplicasProxy() {
        return new WriteActionReplicasProxy();
    }

    @Override
    protected void shardOperationOnPrimary(Request request, BaseIndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>> listener) {
        String executor = this.executorFunction.apply(primary);
        this.threadPool.executor(executor).execute((Runnable)new ActionRunnable<TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>>((ActionListener)listener, (ReplicatedWriteRequest)request, primary){
            final /* synthetic */ ReplicatedWriteRequest val$request;
            final /* synthetic */ BaseIndexShard val$primary;
            {
                this.val$request = replicatedWriteRequest;
                this.val$primary = baseIndexShard;
                super(listener);
            }

            public void doRun() {
                Span span = TransportWriteAction.this.tracer.startSpan(SpanBuilder.from("dispatchedShardOperationOnPrimary", TransportWriteAction.this.clusterService.localNode().getId(), this.val$request));
                try (SpanScope spanScope = TransportWriteAction.this.tracer.withSpanInScope(span);){
                    TransportWriteAction.this.dispatchedShardOperationOnPrimary(this.val$request, this.val$primary, TraceableActionListener.create(this.listener, span, TransportWriteAction.this.tracer));
                }
            }

            public boolean isForceExecution() {
                return TransportWriteAction.this.force(this.val$request);
            }
        });
    }

    protected abstract void dispatchedShardOperationOnPrimary(Request var1, BaseIndexShard var2, ActionListener<TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>> var3);

    @Override
    protected void shardOperationOnReplica(final ReplicaRequest request, final BaseIndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        this.threadPool.executor(this.executorFunction.apply(replica)).execute((Runnable)new ActionRunnable<TransportReplicationAction.ReplicaResult>(listener){

            public void doRun() {
                Span span = TransportWriteAction.this.tracer.startSpan(SpanBuilder.from("dispatchedShardOperationOnReplica", TransportWriteAction.this.clusterService.localNode().getId(), request));
                try (SpanScope spanScope = TransportWriteAction.this.tracer.withSpanInScope(span);){
                    TransportWriteAction.this.dispatchedShardOperationOnReplica(request, replica, TraceableActionListener.create(this.listener, span, TransportWriteAction.this.tracer));
                }
            }

            public boolean isForceExecution() {
                return true;
            }
        });
    }

    protected abstract void dispatchedShardOperationOnReplica(ReplicaRequest var1, BaseIndexShard var2, ActionListener<TransportReplicationAction.ReplicaResult> var3);

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    protected class WriteActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        protected WriteActionReplicasProxy() {
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            if (!TransportActions.isShardNotAvailableException(exception)) {
                TransportWriteAction.this.logger.warn((Message)new ParameterizedMessage("[{}] {}", (Object)replica.shardId(), (Object)message), (Throwable)exception);
            }
            if (!(exception instanceof PrimaryShardClosedException)) {
                TransportWriteAction.this.remoteShardFailedAction.execute(replica.shardId(), replica.allocationId().getId(), primaryTerm, true, message, exception, listener);
            }
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
            TransportWriteAction.this.remoteShardFailedAction.execute(shardId, allocationId, primaryTerm, true, "mark copy as stale", null, listener);
        }
    }

    public static final class AsyncAfterWriteAction {
        private final TranslogLocation location;
        private final boolean waitUntilRefresh;
        private final boolean sync;
        private final AtomicInteger pendingOps = new AtomicInteger(1);
        private final AtomicBoolean refreshed = new AtomicBoolean(false);
        private final AtomicReference<Exception> syncFailure = new AtomicReference<Object>(null);
        private final RespondingWriteResult respond;
        private final BaseIndexShard indexShard;
        private final WriteRequest<?> request;
        private final Logger logger;

        public AsyncAfterWriteAction(BaseIndexShard indexShard, WriteRequest<?> request, @Nullable TranslogLocation location, RespondingWriteResult respond, Logger logger) {
            this.indexShard = indexShard;
            this.request = request;
            boolean waitUntilRefresh = false;
            switch (request.getRefreshPolicy()) {
                case IMMEDIATE: {
                    indexShard.refresh("refresh_flag_index");
                    this.refreshed.set(true);
                    break;
                }
                case WAIT_UNTIL: {
                    if (location == null) break;
                    waitUntilRefresh = true;
                    this.pendingOps.incrementAndGet();
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown refresh policy: " + String.valueOf(request.getRefreshPolicy()));
                }
            }
            this.waitUntilRefresh = waitUntilRefresh;
            this.respond = respond;
            this.location = location;
            this.sync = indexShard.getTranslogDurability() == TranslogSettings.Durability.REQUEST && location != null;
            if (this.sync) {
                this.pendingOps.incrementAndGet();
            }
            this.logger = logger;
            assert (this.pendingOps.get() >= 0 && this.pendingOps.get() <= 3) : "pendingOpts was: " + this.pendingOps.get();
        }

        private void maybeFinish() {
            int numPending = this.pendingOps.decrementAndGet();
            if (numPending == 0) {
                if (this.syncFailure.get() != null) {
                    this.respond.onFailure(this.syncFailure.get());
                } else {
                    this.respond.onSuccess(this.refreshed.get());
                }
            }
            assert (numPending >= 0 && numPending <= 2) : "numPending must either 2, 1 or 0 but was " + numPending;
        }

        public void run() {
            this.indexShard.afterWriteOperation();
            this.maybeFinish();
            if (this.waitUntilRefresh) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.addRefreshListener(this.location, forcedRefresh -> {
                    if (forcedRefresh.booleanValue()) {
                        this.logger.warn("block until refresh ran out of slots and forced a refresh: [{}]", this.request);
                    }
                    this.refreshed.set((boolean)forcedRefresh);
                    this.maybeFinish();
                });
            }
            if (this.sync) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.sync(this.location, ex -> {
                    this.syncFailure.set((Exception)ex);
                    this.maybeFinish();
                });
            }
        }
    }

    public static interface RespondingWriteResult {
        public void onSuccess(boolean var1);

        public void onFailure(Exception var1);
    }

    public static class WriteReplicaResult<ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>>
    extends TransportReplicationAction.ReplicaResult {
        public final TranslogLocation location;
        private final ReplicaRequest request;
        private final BaseIndexShard replica;
        private final Logger logger;

        public WriteReplicaResult(ReplicaRequest request, @Nullable TranslogLocation location, @Nullable Exception operationFailure, BaseIndexShard replica, Logger logger) {
            super(operationFailure);
            this.location = location;
            this.request = request;
            this.replica = replica;
            this.logger = logger;
        }

        @Override
        public void runPostReplicaActions(final ActionListener<Void> listener) {
            if (this.finalFailure != null) {
                listener.onFailure(this.finalFailure);
            } else {
                new AsyncAfterWriteAction(this.replica, (WriteRequest<?>)this.request, this.location, new RespondingWriteResult(){

                    @Override
                    public void onSuccess(boolean forcedRefresh) {
                        listener.onResponse(null);
                    }

                    @Override
                    public void onFailure(Exception ex) {
                        listener.onFailure(ex);
                    }
                }, this.logger).run();
            }
        }
    }

    public static class WritePrimaryResult<ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>, Response extends ReplicationResponse>
    extends TransportReplicationAction.PrimaryResult<ReplicaRequest, Response> {
        public final TranslogLocation location;
        public final BaseIndexShard primary;
        private final Logger logger;

        public WritePrimaryResult(ReplicaRequest request, @Nullable Response finalResponse, @Nullable TranslogLocation location, @Nullable Exception operationFailure, BaseIndexShard primary, Logger logger) {
            super(request, finalResponse, operationFailure);
            this.location = location;
            this.primary = primary;
            this.logger = logger;
            assert (location == null || operationFailure == null) : "expected either failure to be null or translog location to be null, but found: [" + String.valueOf(location) + "] translog location and [" + String.valueOf(operationFailure) + "] failure";
        }

        @Override
        public void runPostReplicationActions(final ActionListener<Void> listener) {
            if (this.finalFailure != null) {
                listener.onFailure(this.finalFailure);
            } else {
                new AsyncAfterWriteAction(this.primary, (WriteRequest)((Object)this.replicaRequest), this.location, new RespondingWriteResult(){

                    @Override
                    public void onSuccess(boolean forcedRefresh) {
                        ((WriteResponse)((Object)finalResponseIfSuccessful)).setForcedRefresh(forcedRefresh);
                        listener.onResponse(null);
                    }

                    @Override
                    public void onFailure(Exception ex) {
                        listener.onFailure(ex);
                    }
                }, this.logger).run();
            }
        }
    }
}

