/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.termvectors;

import io.skylite.OpenSearchVersion;
import io.skylite.SkyliteException;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.termvectors.MultiTermVectorsItemResponse;
import io.skylite.core.action.termvectors.TermVectorsResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public class MultiTermVectorsResponse
extends ActionResponse
implements Iterable<MultiTermVectorsItemResponse>,
ToXContentObject {
    private final MultiTermVectorsItemResponse[] responses;

    public MultiTermVectorsResponse(MultiTermVectorsItemResponse[] responses) {
        this.responses = responses;
    }

    public MultiTermVectorsResponse(StreamInput in) throws IOException {
        super(in);
        this.responses = in.readArray(MultiTermVectorsItemResponse::new, MultiTermVectorsItemResponse[]::new);
    }

    public MultiTermVectorsItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public Iterator<MultiTermVectorsItemResponse> iterator() {
        return Arrays.stream(this.responses).iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("docs");
        for (MultiTermVectorsItemResponse response : this.responses) {
            if (response.isFailed()) {
                builder.startObject();
                Failure failure = response.getFailure();
                builder.field("_index", failure.getIndex());
                builder.field("_id", failure.getId());
                SkyliteException.generateFailureXContent(builder, params, failure.getCause(), true);
                builder.endObject();
                continue;
            }
            TermVectorsResponse getResponse = response.getResponse();
            getResponse.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(this.responses);
    }

    static final class Fields {
        static final String DOCS = "docs";
        static final String _INDEX = "_index";
        static final String _ID = "_id";

        Fields() {
        }
    }

    public static class Failure
    implements Writeable {
        private final String index;
        private final String id;
        private final Exception cause;

        public Failure(String index, String id, Exception cause) {
            this.index = index;
            this.id = id;
            this.cause = cause;
        }

        public Failure(StreamInput in) throws IOException {
            this.index = in.readString();
            if (in.getVersion().before(OpenSearchVersion.V_2_0_0)) {
                in.readOptionalString();
            }
            this.id = in.readString();
            this.cause = in.readException();
        }

        public String getIndex() {
            return this.index;
        }

        public String getId() {
            return this.id;
        }

        public Exception getCause() {
            return this.cause;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            if (out.getVersion().before(OpenSearchVersion.V_2_0_0)) {
                out.writeOptionalString(null);
            }
            out.writeString(this.id);
            out.writeException(this.cause);
        }
    }
}

