/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.common.CheckedFunction;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.AggregationReduceableSearchResult;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.BucketCollector;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.aggregations.MultiBucketCollector;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.query.ReduceableSearchResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;

public abstract class AggregationCollectorManager
implements CollectorManager<Collector, ReduceableSearchResult> {
    protected final SearchExecutionContext context;
    private final CheckedFunction<SearchExecutionContext, List<Aggregator>, IOException> aggProvider;
    private final String collectorReason;

    protected AggregationCollectorManager(SearchExecutionContext context, CheckedFunction<SearchExecutionContext, List<Aggregator>, IOException> aggProvider, String collectorReason) {
        this.context = context;
        this.aggProvider = aggProvider;
        this.collectorReason = collectorReason;
    }

    public Collector newCollector() throws IOException {
        Collector collector = AggregationCollectorManager.createCollector((List)this.aggProvider.apply((Object)this.context));
        assert (collector != BucketCollector.NO_OP_COLLECTOR);
        return collector;
    }

    public String getCollectorReason() {
        return this.collectorReason;
    }

    public abstract String getCollectorName();

    public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
        List<Aggregator> aggregators = this.context.bucketCollectorProcessor().toAggregators(collectors);
        ArrayList<InternalAggregation> internals = new ArrayList<InternalAggregation>(aggregators.size());
        this.context.aggregations().resetBucketMultiConsumer();
        for (Aggregator aggregator : aggregators) {
            try {
                internals.add(aggregator.buildTopLevel());
            }
            catch (IOException e) {
                throw new AggregationExecutionException("Failed to build aggregation [" + aggregator.name() + "]", e);
            }
        }
        InternalAggregations internalAggregations = InternalAggregations.from(internals);
        return this.buildAggregationResult(internalAggregations);
    }

    protected AggregationReduceableSearchResult buildAggregationResult(InternalAggregations internalAggregations) {
        return new AggregationReduceableSearchResult(internalAggregations);
    }

    static Collector createCollector(List<Aggregator> collectors) throws IOException {
        BucketCollector collector = MultiBucketCollector.wrap(collectors);
        collector.preCollection();
        return collector;
    }
}

