/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregationUsageService;
import io.skylite.core.aggregations.FieldContext;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.query.NestedScope;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptContext;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.search.sort.SortAndFormats;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public abstract class AggregationContext {
    public abstract Query query();

    public abstract long nowInMillis();

    public final FieldContext buildFieldContext(String field) {
        MappedFieldType ft = this.getFieldType(field);
        if (ft == null) {
            return null;
        }
        return new FieldContext(field, this.buildFieldData(ft), ft);
    }

    public final FieldContext buildFieldContext(MappedFieldType ft) {
        return new FieldContext(ft.name(), this.buildFieldData(ft), ft);
    }

    protected abstract IndexFieldData<?> buildFieldData(MappedFieldType var1);

    public abstract MappedFieldType getFieldType(String var1);

    public abstract boolean isFieldMapped(String var1);

    public abstract <FactoryType> FactoryType compile(Script var1, ScriptContext<FactoryType> var2);

    public abstract SearchLookup lookup();

    public abstract AggregationRegistry getAggregationRegistry();

    public final AggregationUsageService getUsageService() {
        return this.getAggregationRegistry().getUsageService();
    }

    public abstract BigArrays bigArrays();

    public abstract IndexSearcher searcher();

    public abstract Query buildQuery(QueryBuilder var1) throws IOException;

    public abstract IndexSettings getIndexSettings();

    public abstract Optional<SortAndFormats> buildSort(List<? extends BaseSortBuilder> var1) throws IOException;

    public abstract ObjectMapper getObjectMapper(String var1);

    public abstract NestedScope nestedScope();
}

