/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.SkyliteParseException;
import io.skylite.common.lease.Releasable;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.BucketCollector;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.bucket.SingleBucketAggregator;
import io.skylite.core.aggregations.support.AggregationPath;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.BiConsumer;

public abstract class Aggregator
extends BucketCollector
implements Releasable {
    public abstract String name();

    public abstract SearchExecutionContext context();

    public abstract Aggregator parent();

    public abstract Aggregator subAggregator(String var1);

    public final Aggregator resolveSortPathOnValidAgg(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        Aggregator n = this.subAggregator(next.name);
        if (n == null) {
            throw new IllegalArgumentException("The provided aggregation [" + String.valueOf(next) + "] either does not exist, or is a pipeline aggregation and cannot be used to sort the buckets.");
        }
        if (!path.hasNext()) {
            return n;
        }
        if (next.key != null) {
            throw new IllegalArgumentException("Key only allowed on last aggregation path element but got [" + String.valueOf(next) + "]");
        }
        return n.resolveSortPath(path.next(), path);
    }

    public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        throw new IllegalArgumentException("Buckets can only be sorted on a sub-aggregator path that is built out of zero or more single-bucket aggregations within the path and a final single-bucket or a metrics aggregation at the path end. [" + this.name() + "] is not single-bucket.");
    }

    public BucketOrder.BucketComparator bucketComparator(String key, SortOrder order) {
        throw new IllegalArgumentException("Buckets can only be sorted on a sub-aggregator path that is built out of zero or more single-bucket aggregations within the path and a final single-bucket or a metrics aggregation at the path end.");
    }

    public abstract InternalAggregation[] buildAggregations(long[] var1) throws IOException;

    public final InternalAggregation buildTopLevel() throws IOException {
        assert (this.parent() == null);
        return this.buildAggregations(new long[]{0L})[0];
    }

    public abstract InternalAggregation buildEmptyAggregation();

    public void collectDebugInfo(BiConsumer<String, Object> add) {
    }

    public boolean isCompatibleForTopmost() {
        return this instanceof SingleBucketAggregator;
    }

    public Aggregator unwrap() {
        return this;
    }

    public static enum SubAggCollectionMode implements Writeable
    {
        DEPTH_FIRST(new ParseField("depth_first", new String[0])),
        BREADTH_FIRST(new ParseField("breadth_first", new String[0]));

        public static final ParseField KEY;
        private final ParseField parseField;

        private SubAggCollectionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        public ParseField parseField() {
            return this.parseField;
        }

        public static SubAggCollectionMode parse(String value, DeprecationHandler deprecationHandler) {
            SubAggCollectionMode[] modes;
            for (SubAggCollectionMode mode : modes = SubAggCollectionMode.values()) {
                if (!mode.parseField.match(value, deprecationHandler)) continue;
                return mode;
            }
            throw new SkyliteParseException("no [{}] found for value [{}]", KEY.getPreferredName(), value);
        }

        public static SubAggCollectionMode readFromStream(StreamInput in) throws IOException {
            return in.readEnum(SubAggCollectionMode.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        static {
            KEY = new ParseField("collect_mode", new String[0]);
        }
    }

    @FunctionalInterface
    public static interface Parser {
        public AggregationBuilder parse(String var1, XContentParser var2) throws IOException;
    }
}

