/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.BaseAggregationBuilder;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.PipelineAggregationBuilder;
import io.skylite.core.aggregations.pipeline.PipelineAggregator;
import io.skylite.core.aggregations.support.AggregationPath;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.profile.Profilers;
import io.skylite.core.search.profile.aggregation.ProfilingAggregator;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedObjectNotFoundException;
import io.skylite.core.xcontent.SuggestingErrorOnUnknown;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentLocation;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AggregatorFactories {
    public static final Pattern VALID_AGG_NAME = Pattern.compile("[^\\[\\]>]+");
    public static final AggregatorFactories EMPTY = new AggregatorFactories(new AggregatorFactory[0]);
    private static final Predicate<AggregatorFactory> GLOBAL_AGGREGATOR_FACTORY_PREDICATE = AggregatorFactory::isGlobalAggregation;
    private AggregatorFactory[] factories;

    public static Builder parseAggregators(XContentParser parser) throws IOException {
        return AggregatorFactories.parseAggregators(parser, 0);
    }

    private static Builder parseAggregators(XContentParser parser, int level) throws IOException {
        Matcher validAggMatcher = VALID_AGG_NAME.matcher("");
        Builder factories = new Builder();
        XContentParser.Token token = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf((Object)token) + " in [aggs]: aggregations definitions must start with the name of the aggregation.", new Object[0]);
            }
            String aggregationName = parser.currentName();
            if (!validAggMatcher.reset(aggregationName).matches()) {
                throw new ParsingException(parser.getTokenLocation(), "Invalid aggregation name [" + aggregationName + "]. Aggregation names can contain any character except '[', ']', and '>'", new Object[0]);
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Aggregation definition for [" + aggregationName + " starts with a [" + String.valueOf((Object)token) + "], expected a [" + String.valueOf((Object)XContentParser.Token.START_OBJECT) + "].", new Object[0]);
            }
            BaseAggregationBuilder aggBuilder = null;
            Builder subFactories = null;
            Map<String, Object> metadata = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf((Object)XContentParser.Token.FIELD_NAME) + "] under a [" + String.valueOf((Object)XContentParser.Token.START_OBJECT) + "], but got a [" + String.valueOf((Object)token) + "] in [" + aggregationName + "]", parser.getTokenLocation());
                }
                String fieldName = parser.currentName();
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    switch (fieldName) {
                        case "meta": {
                            metadata = parser.map();
                            break;
                        }
                        case "aggregations": 
                        case "aggs": {
                            if (subFactories != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two sub aggregation definitions under [" + aggregationName + "]", new Object[0]);
                            }
                            subFactories = AggregatorFactories.parseAggregators(parser, level + 1);
                            break;
                        }
                        default: {
                            if (aggBuilder != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two aggregation type definitions in [" + aggregationName + "]: [" + aggBuilder.getType() + "] and [" + fieldName + "]", new Object[0]);
                            }
                            try {
                                aggBuilder = parser.namedObject(BaseAggregationBuilder.class, fieldName, aggregationName);
                                break;
                            }
                            catch (NamedObjectNotFoundException ex) {
                                String message = String.format(Locale.ROOT, "Unknown aggregation type [%s]%s", fieldName, SuggestingErrorOnUnknown.suggest(fieldName, ex.getCandidates()));
                                throw new ParsingException(new XContentLocation(ex.getLineNumber(), ex.getColumnNumber()), message, ex, new Object[0]);
                            }
                        }
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf((Object)XContentParser.Token.START_OBJECT) + "] under [" + fieldName + "], but got a [" + String.valueOf((Object)token) + "] in [" + aggregationName + "]", new Object[0]);
            }
            if (aggBuilder == null) {
                throw new ParsingException(parser.getTokenLocation(), "Missing definition for aggregation [" + aggregationName + "]", parser.getTokenLocation());
            }
            if (metadata != null) {
                aggBuilder.setMetadata(metadata);
            }
            if (subFactories != null) {
                aggBuilder.subAggregations(subFactories);
            }
            if (aggBuilder instanceof AggregationBuilder) {
                factories.addAggregator((AggregationBuilder)aggBuilder);
                continue;
            }
            factories.addPipelineAggregator((PipelineAggregationBuilder)aggBuilder);
        }
        return factories.count() > 0 ? factories : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    private AggregatorFactories(AggregatorFactory[] factories) {
        this.factories = factories;
    }

    public boolean allFactoriesSupportConcurrentSearch() {
        for (AggregatorFactory factory : this.factories) {
            if (factory.supportsConcurrentSegmentSearch() && factory.evaluateChildFactories()) continue;
            return false;
        }
        return true;
    }

    public Aggregator[] createSubAggregators(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality) throws IOException {
        Aggregator[] aggregators = new Aggregator[this.countAggregators()];
        for (int i = 0; i < this.factories.length; ++i) {
            Aggregator factory = this.factories[i].create(searchContext, parent, cardinality);
            Profilers profilers = factory.context().getProfilers();
            if (profilers != null) {
                factory = new ProfilingAggregator(factory, profilers.getAggregationProfiler());
            }
            aggregators[i] = factory;
        }
        return aggregators;
    }

    public List<Aggregator> createTopLevelAggregators(SearchExecutionContext searchContext) throws IOException {
        return this.createTopLevelAggregators(searchContext, aggregatorFactory -> true);
    }

    public List<Aggregator> createTopLevelGlobalAggregators(SearchExecutionContext searchContext) throws IOException {
        return this.createTopLevelAggregators(searchContext, GLOBAL_AGGREGATOR_FACTORY_PREDICATE);
    }

    public List<Aggregator> createTopLevelNonGlobalAggregators(SearchExecutionContext searchContext) throws IOException {
        return this.createTopLevelAggregators(searchContext, GLOBAL_AGGREGATOR_FACTORY_PREDICATE.negate());
    }

    private List<Aggregator> createTopLevelAggregators(SearchExecutionContext searchContext, Predicate<AggregatorFactory> factoryFilter) throws IOException {
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        for (int i = 0; i < this.factories.length; ++i) {
            if (!factoryFilter.test(this.factories[i])) continue;
            Aggregator factory = this.factories[i].create(searchContext, null, CardinalityUpperBound.ONE);
            Profilers profilers = factory.context().getProfilers();
            if (profilers != null) {
                factory = new ProfilingAggregator(factory, profilers.getAggregationProfiler());
            }
            aggregators.add(factory);
        }
        return aggregators;
    }

    public boolean hasNonGlobalAggregator() {
        return Arrays.stream(this.factories).anyMatch(GLOBAL_AGGREGATOR_FACTORY_PREDICATE.negate());
    }

    public boolean hasGlobalAggregator() {
        return Arrays.stream(this.factories).anyMatch(GLOBAL_AGGREGATOR_FACTORY_PREDICATE);
    }

    public int countAggregators() {
        return this.factories.length;
    }

    public static class Builder
    implements Writeable,
    ToXContentObject {
        private final Set<String> names = new HashSet<String>();
        private final Collection<AggregationBuilder> aggregationBuilders = new LinkedHashSet<AggregationBuilder>();
        private final Collection<PipelineAggregationBuilder> pipelineAggregatorBuilders = new LinkedHashSet<PipelineAggregationBuilder>();

        public Builder() {
        }

        public Builder(StreamInput in) throws IOException {
            int factoriesSize = in.readVInt();
            for (int i = 0; i < factoriesSize; ++i) {
                this.addAggregator(in.readNamedWriteable(AggregationBuilder.class));
            }
            int pipelineFactoriesSize = in.readVInt();
            for (int i = 0; i < pipelineFactoriesSize; ++i) {
                this.addPipelineAggregator(in.readNamedWriteable(PipelineAggregationBuilder.class));
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.aggregationBuilders.size());
            for (AggregationBuilder aggregationBuilder : this.aggregationBuilders) {
                out.writeNamedWriteable(aggregationBuilder);
            }
            out.writeVInt(this.pipelineAggregatorBuilders.size());
            for (PipelineAggregationBuilder pipelineAggregationBuilder : this.pipelineAggregatorBuilders) {
                out.writeNamedWriteable(pipelineAggregationBuilder);
            }
        }

        public boolean mustVisitAllDocs() {
            for (AggregationBuilder builder : this.aggregationBuilders) {
                if (!builder.mustVisitAllDocs()) continue;
                return true;
            }
            return false;
        }

        public Builder addAggregator(AggregationBuilder factory) {
            if (!this.names.add(factory.name)) {
                throw new IllegalArgumentException("Two sibling aggregations cannot have the same name: [" + factory.name + "]");
            }
            this.aggregationBuilders.add(factory);
            return this;
        }

        public Builder addPipelineAggregator(PipelineAggregationBuilder pipelineAggregatorFactory) {
            this.pipelineAggregatorBuilders.add(pipelineAggregatorFactory);
            return this;
        }

        public ActionRequestValidationException validate(ActionRequestValidationException e) {
            PipelineAggregationBuilder.ValidationContext context = PipelineAggregationBuilder.ValidationContext.forTreeRoot(this.aggregationBuilders, this.pipelineAggregatorBuilders, e);
            this.validatePipelines(context);
            return this.validateChildren(context.getValidationException());
        }

        private void validatePipelines(PipelineAggregationBuilder.ValidationContext context) {
            List<PipelineAggregationBuilder> orderedPipelineAggregators;
            try {
                orderedPipelineAggregators = this.resolvePipelineAggregatorOrder(this.pipelineAggregatorBuilders, this.aggregationBuilders);
            }
            catch (IllegalArgumentException iae) {
                context.addValidationError(iae.getMessage());
                return;
            }
            for (PipelineAggregationBuilder builder : orderedPipelineAggregators) {
                builder.validate(context);
            }
        }

        private ActionRequestValidationException validateChildren(ActionRequestValidationException e) {
            for (AggregationBuilder agg : this.aggregationBuilders) {
                PipelineAggregationBuilder.ValidationContext context = PipelineAggregationBuilder.ValidationContext.forInsideTree(agg, e);
                agg.factoriesBuilder.validatePipelines(context);
                e = agg.factoriesBuilder.validateChildren(context.getValidationException());
            }
            return e;
        }

        public AggregatorFactories build(AggregationContext context, AggregatorFactory parent) throws IOException {
            if (this.aggregationBuilders.isEmpty() && this.pipelineAggregatorBuilders.isEmpty()) {
                return EMPTY;
            }
            AggregatorFactory[] aggFactories = new AggregatorFactory[this.aggregationBuilders.size()];
            int i = 0;
            for (AggregationBuilder agg : this.aggregationBuilders) {
                aggFactories[i] = agg.build(context, parent);
                ++i;
            }
            return new AggregatorFactories(aggFactories);
        }

        private List<PipelineAggregationBuilder> resolvePipelineAggregatorOrder(Collection<PipelineAggregationBuilder> pipelineAggregatorBuilders, Collection<AggregationBuilder> aggregationBuilders) {
            HashMap<String, PipelineAggregationBuilder> pipelineAggregatorBuildersMap = new HashMap<String, PipelineAggregationBuilder>();
            for (PipelineAggregationBuilder pipelineAggregationBuilder : pipelineAggregatorBuilders) {
                pipelineAggregatorBuildersMap.put(pipelineAggregationBuilder.getName(), pipelineAggregationBuilder);
            }
            HashMap<String, AggregationBuilder> aggBuildersMap = new HashMap<String, AggregationBuilder>();
            for (AggregationBuilder aggBuilder : aggregationBuilders) {
                aggBuildersMap.put(aggBuilder.name, aggBuilder);
            }
            LinkedList<PipelineAggregationBuilder> linkedList = new LinkedList<PipelineAggregationBuilder>();
            ArrayList<PipelineAggregationBuilder> unmarkedBuilders = new ArrayList<PipelineAggregationBuilder>(pipelineAggregatorBuilders);
            HashSet<PipelineAggregationBuilder> temporarilyMarked = new HashSet<PipelineAggregationBuilder>();
            while (!unmarkedBuilders.isEmpty()) {
                PipelineAggregationBuilder builder = (PipelineAggregationBuilder)unmarkedBuilders.get(0);
                this.resolvePipelineAggregatorOrder(aggBuildersMap, pipelineAggregatorBuildersMap, linkedList, unmarkedBuilders, temporarilyMarked, builder);
            }
            return linkedList;
        }

        private void resolvePipelineAggregatorOrder(Map<String, AggregationBuilder> aggBuildersMap, Map<String, PipelineAggregationBuilder> pipelineAggregatorBuildersMap, List<PipelineAggregationBuilder> orderedPipelineAggregators, List<PipelineAggregationBuilder> unmarkedBuilders, Collection<PipelineAggregationBuilder> temporarilyMarked, PipelineAggregationBuilder builder) {
            if (temporarilyMarked.contains(builder)) {
                throw new IllegalArgumentException("Cyclical dependency found with pipeline aggregator [" + builder.getName() + "]");
            }
            if (unmarkedBuilders.contains(builder)) {
                String[] bucketsPaths;
                temporarilyMarked.add(builder);
                block0: for (String bucketsPath : bucketsPaths = builder.getBucketsPaths()) {
                    List<AggregationPath.PathElement> bucketsPathElements = AggregationPath.parse(bucketsPath).getPathElements();
                    String firstAggName = bucketsPathElements.get((int)0).name;
                    if (bucketsPath.equals("_count") || bucketsPath.equals("_key")) continue;
                    if (aggBuildersMap.containsKey(firstAggName)) {
                        AggregationBuilder aggBuilder = aggBuildersMap.get(firstAggName);
                        for (int i = 1; i < bucketsPathElements.size(); ++i) {
                            AggregationPath.PathElement pathElement = bucketsPathElements.get(i);
                            String aggName = pathElement.name;
                            if (i == bucketsPathElements.size() - 1 && (aggName.equalsIgnoreCase("_key") || aggName.equals("_count"))) continue block0;
                            Collection<AggregationBuilder> subBuilders = aggBuilder.factoriesBuilder.aggregationBuilders;
                            boolean foundSubBuilder = false;
                            for (AggregationBuilder subBuilder : subBuilders) {
                                if (!aggName.equals(subBuilder.name)) continue;
                                aggBuilder = subBuilder;
                                foundSubBuilder = true;
                                break;
                            }
                            if (!foundSubBuilder && i == bucketsPathElements.size() - 1) {
                                Collection<PipelineAggregationBuilder> subPipelineBuilders = aggBuilder.factoriesBuilder.pipelineAggregatorBuilders;
                                for (PipelineAggregationBuilder subFactory : subPipelineBuilders) {
                                    if (!aggName.equals(subFactory.getName())) continue;
                                    foundSubBuilder = true;
                                    break;
                                }
                            }
                            if (foundSubBuilder) continue;
                            throw new IllegalArgumentException("No aggregation [" + aggName + "] found for path [" + bucketsPath + "]");
                        }
                        continue;
                    }
                    PipelineAggregationBuilder matchingBuilder = pipelineAggregatorBuildersMap.get(firstAggName);
                    if (matchingBuilder != null) {
                        this.resolvePipelineAggregatorOrder(aggBuildersMap, pipelineAggregatorBuildersMap, orderedPipelineAggregators, unmarkedBuilders, temporarilyMarked, matchingBuilder);
                        continue;
                    }
                    throw new IllegalArgumentException("No aggregation found for path [" + bucketsPath + "]");
                }
                unmarkedBuilders.remove(builder);
                temporarilyMarked.remove(builder);
                orderedPipelineAggregators.add(builder);
            }
        }

        public Collection<AggregationBuilder> getAggregatorFactories() {
            return Collections.unmodifiableCollection(this.aggregationBuilders);
        }

        public Collection<PipelineAggregationBuilder> getPipelineAggregatorFactories() {
            return Collections.unmodifiableCollection(this.pipelineAggregatorBuilders);
        }

        public int count() {
            return this.aggregationBuilders.size() + this.pipelineAggregatorBuilders.size();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.aggregationBuilders != null) {
                for (AggregationBuilder aggregationBuilder : this.aggregationBuilders) {
                    aggregationBuilder.toXContent(builder, params);
                }
            }
            if (this.pipelineAggregatorBuilders != null) {
                for (PipelineAggregationBuilder pipelineAggregationBuilder : this.pipelineAggregatorBuilders) {
                    pipelineAggregationBuilder.toXContent(builder, params);
                }
            }
            builder.endObject();
            return builder;
        }

        public String toString() {
            return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
        }

        public int hashCode() {
            return Objects.hash(this.aggregationBuilders, this.pipelineAggregatorBuilders);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (!Objects.equals(this.aggregationBuilders, other.aggregationBuilders)) {
                return false;
            }
            return Objects.equals(this.pipelineAggregatorBuilders, other.pipelineAggregatorBuilders);
        }

        public Builder rewrite(QueryRewriteContext context) throws IOException {
            Rewriteable<AggregationBuilder> result;
            boolean changed = false;
            Builder newBuilder = new Builder();
            for (AggregationBuilder aggregationBuilder : this.aggregationBuilders) {
                result = Rewriteable.rewrite(aggregationBuilder, context);
                newBuilder.addAggregator((AggregationBuilder)result);
                changed |= result != aggregationBuilder;
            }
            for (PipelineAggregationBuilder pipelineAggregationBuilder : this.pipelineAggregatorBuilders) {
                result = Rewriteable.rewrite(pipelineAggregationBuilder, context);
                newBuilder.addPipelineAggregator((PipelineAggregationBuilder)result);
                changed |= result != pipelineAggregationBuilder;
            }
            return changed ? newBuilder : this;
        }

        public PipelineAggregator.PipelineTree buildPipelineTree() {
            if (this.aggregationBuilders.isEmpty() && this.pipelineAggregatorBuilders.isEmpty()) {
                return PipelineAggregator.PipelineTree.EMPTY;
            }
            Map<String, PipelineAggregator.PipelineTree> subTrees = this.aggregationBuilders.stream().collect(Collectors.toMap(AggregationBuilder::getName, AggregationBuilder::buildPipelineTree));
            List<PipelineAggregator> aggregators = this.resolvePipelineAggregatorOrder(this.pipelineAggregatorBuilders, this.aggregationBuilders).stream().map(PipelineAggregationBuilder::create).collect(Collectors.toList());
            return new PipelineAggregator.PipelineTree(subTrees, aggregators);
        }
    }
}

