/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.common.CheckedFunction;
import io.skylite.core.aggregations.AggregationCollectorManager;
import io.skylite.core.aggregations.AggregationReduceableSearchResult;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Collector;

public class GlobalAggCollectorManager
extends AggregationCollectorManager {
    private Collector collector = Objects.requireNonNull(super.newCollector(), "collector instance is null");
    private final String collectorName = this.collector.toString();

    public GlobalAggCollectorManager(SearchExecutionContext context) throws IOException {
        super(context, (CheckedFunction<SearchExecutionContext, List<Aggregator>, IOException>)((CheckedFunction)context.aggregations().factories()::createTopLevelGlobalAggregators), "aggregation_global");
    }

    @Override
    public Collector newCollector() throws IOException {
        if (this.collector != null) {
            Collector toReturn = this.collector;
            this.collector = null;
            return toReturn;
        }
        return super.newCollector();
    }

    @Override
    protected AggregationReduceableSearchResult buildAggregationResult(InternalAggregations internalAggregations) {
        return new AggregationReduceableSearchResult(InternalAggregations.reduce(Collections.singletonList(internalAggregations), this.context.partialOnShard()));
    }

    @Override
    public String getCollectorName() {
        return this.collectorName;
    }
}

