/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.aggregations.pipeline.PipelineAggregator;
import io.skylite.core.aggregations.support.AggregationPath;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.script.ScriptService;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Supplier;

public abstract class InternalAggregation
implements Aggregation,
NamedWriteable {
    protected final String name;
    protected final Map<String, Object> metadata;

    protected InternalAggregation(String name, Map<String, Object> metadata) {
        this.name = name;
        this.metadata = metadata;
    }

    protected InternalAggregation(StreamInput in) throws IOException {
        this.name = in.readString();
        this.metadata = in.readMap();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeGenericValue(this.metadata);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public String getName() {
        return this.name;
    }

    public InternalAggregation copyWithRewritenBuckets(Function<InternalAggregations, InternalAggregations> rewriter) {
        throw new IllegalStateException("Aggregation [" + this.getName() + "] must be a bucket aggregation but was [" + this.getWriteableName() + "]");
    }

    public void forEachBucket(Consumer<InternalAggregations> consumer) {
    }

    public InternalAggregation reducePipelines(InternalAggregation reducedAggs, ReduceContext reduceContext, PipelineAggregator.PipelineTree pipelinesForThisAgg) {
        assert (reduceContext.isFinalReduce());
        for (PipelineAggregator pipelineAggregator : pipelinesForThisAgg.aggregators()) {
            reducedAggs = pipelineAggregator.reduce(reducedAggs, reduceContext);
        }
        return reducedAggs;
    }

    public abstract InternalAggregation reduce(List<InternalAggregation> var1, ReduceContext var2);

    protected abstract boolean mustReduceOnSingleInternalAgg();

    public boolean isMapped() {
        return true;
    }

    public Object getProperty(String path) {
        AggregationPath aggPath = AggregationPath.parse(path);
        return this.getProperty(aggPath.getPathElementsAsStringList());
    }

    public abstract Object getProperty(List<String> var1);

    protected static int readSize(StreamInput in) throws IOException {
        int size = in.readVInt();
        return size == 0 ? Integer.MAX_VALUE : size;
    }

    protected static void writeSize(int size, StreamOutput out) throws IOException {
        if (size == Integer.MAX_VALUE) {
            size = 0;
        }
        out.writeVInt(size);
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getType() {
        return this.getWriteableName();
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (params.paramAsBoolean("typed_keys", false)) {
            builder.startObject(String.join((CharSequence)"#", this.getType(), this.getName()));
        } else {
            builder.startObject(this.getName());
        }
        if (this.metadata != null) {
            builder.field(Aggregation.CommonFields.META.getPreferredName());
            builder.map(this.metadata);
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(this.name, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        InternalAggregation other = (InternalAggregation)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.metadata, other.metadata);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public double sortValue(String key) {
        throw new IllegalArgumentException("Can't sort a [" + this.getType() + "] aggregation [" + this.getName() + "]");
    }

    public double sortValue(AggregationPath.PathElement head, Iterator<AggregationPath.PathElement> tail) {
        throw new IllegalArgumentException("Can't sort by a descendant of a [" + this.getType() + "] aggregation [" + String.valueOf(head) + "]");
    }

    public static class ReduceContext {
        private final BigArrays bigArrays;
        private final ScriptService scriptService;
        private final IntConsumer multiBucketConsumer;
        private final PipelineAggregator.PipelineTree pipelineTreeRoot;
        private boolean isSliceLevel;
        private final Supplier<PipelineAggregator.PipelineTree> pipelineTreeForBwcSerialization;

        public static ReduceContext forPartialReduction(BigArrays bigArrays, ScriptService scriptService, Supplier<PipelineAggregator.PipelineTree> pipelineTreeForBwcSerialization) {
            return new ReduceContext(bigArrays, scriptService, s -> {}, null, pipelineTreeForBwcSerialization);
        }

        public static ReduceContext forFinalReduction(BigArrays bigArrays, ScriptService scriptService, IntConsumer multiBucketConsumer, PipelineAggregator.PipelineTree pipelineTreeRoot) {
            return new ReduceContext(bigArrays, scriptService, multiBucketConsumer, Objects.requireNonNull(pipelineTreeRoot, "prefer EMPTY to null"), () -> pipelineTreeRoot);
        }

        private ReduceContext(BigArrays bigArrays, ScriptService scriptService, IntConsumer multiBucketConsumer, PipelineAggregator.PipelineTree pipelineTreeRoot, Supplier<PipelineAggregator.PipelineTree> pipelineTreeForBwcSerialization) {
            this.bigArrays = bigArrays;
            this.scriptService = scriptService;
            this.multiBucketConsumer = multiBucketConsumer;
            this.pipelineTreeRoot = pipelineTreeRoot;
            this.pipelineTreeForBwcSerialization = pipelineTreeForBwcSerialization;
            this.isSliceLevel = false;
        }

        public boolean isFinalReduce() {
            return this.pipelineTreeRoot != null;
        }

        public void setSliceLevel(boolean sliceLevel) {
            this.isSliceLevel = sliceLevel;
        }

        public boolean isSliceLevel() {
            return this.isSliceLevel;
        }

        public BigArrays bigArrays() {
            return this.bigArrays;
        }

        public ScriptService scriptService() {
            return this.scriptService;
        }

        public PipelineAggregator.PipelineTree pipelineTreeRoot() {
            return this.pipelineTreeRoot;
        }

        public Supplier<PipelineAggregator.PipelineTree> pipelineTreeForBwcSerialization() {
            return this.pipelineTreeForBwcSerialization;
        }

        public void consumeBucketsAndMaybeBreak(int size) {
            this.multiBucketConsumer.accept(size);
        }
    }

    public static interface ReduceContextBuilder {
        public ReduceContext forPartialReduction();

        public ReduceContext forFinalReduction();
    }
}

