/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.core.aggregations.BucketCollector;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.lucene.ScoreCachingScorable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;

public class MultiBucketCollector
extends BucketCollector {
    private final boolean cacheScores;
    private final BucketCollector[] collectors;

    public static BucketCollector wrap(BucketCollector ... collectors) {
        return MultiBucketCollector.wrap(Arrays.asList(collectors));
    }

    public static BucketCollector wrap(Iterable<? extends BucketCollector> collectors) {
        int n = 0;
        for (BucketCollector bucketCollector : collectors) {
            if (bucketCollector == NO_OP_COLLECTOR) continue;
            ++n;
        }
        if (n == 0) {
            return NO_OP_COLLECTOR;
        }
        if (n == 1) {
            BucketCollector col = null;
            for (BucketCollector bucketCollector : collectors) {
                if (bucketCollector == null) continue;
                col = bucketCollector;
                break;
            }
            return col;
        }
        BucketCollector[] colls = new BucketCollector[n];
        n = 0;
        for (BucketCollector bucketCollector : collectors) {
            if (bucketCollector == null) continue;
            colls[n++] = bucketCollector;
        }
        return new MultiBucketCollector(colls);
    }

    private MultiBucketCollector(BucketCollector ... collectors) {
        this.collectors = collectors;
        int numNeedsScores = 0;
        for (BucketCollector collector : collectors) {
            if (!collector.scoreMode().needsScores()) continue;
            ++numNeedsScores;
        }
        this.cacheScores = numNeedsScores >= 2;
    }

    public BucketCollector[] getCollectors() {
        return this.collectors;
    }

    public ScoreMode scoreMode() {
        ScoreMode scoreMode = null;
        for (BucketCollector collector : this.collectors) {
            if (scoreMode == null) {
                scoreMode = collector.scoreMode();
                continue;
            }
            if (scoreMode == collector.scoreMode()) continue;
            return ScoreMode.COMPLETE;
        }
        return scoreMode;
    }

    @Override
    public void preCollection() throws IOException {
        for (BucketCollector collector : this.collectors) {
            collector.preCollection();
        }
    }

    @Override
    public void postCollection() throws IOException {
        for (BucketCollector collector : this.collectors) {
            collector.postCollection();
        }
    }

    public String toString() {
        return Arrays.toString(this.collectors);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext context) throws IOException {
        ArrayList<LeafBucketCollector> leafCollectors = new ArrayList<LeafBucketCollector>();
        for (BucketCollector collector : this.collectors) {
            LeafBucketCollector leafCollector;
            try {
                leafCollector = collector.getLeafCollector(context);
            }
            catch (CollectionTerminatedException e) {
                continue;
            }
            leafCollectors.add(leafCollector);
        }
        switch (leafCollectors.size()) {
            case 0: {
                throw new CollectionTerminatedException();
            }
            case 1: {
                return (LeafBucketCollector)leafCollectors.get(0);
            }
        }
        return new MultiLeafBucketCollector(leafCollectors, this.cacheScores);
    }

    private static class MultiLeafBucketCollector
    extends LeafBucketCollector {
        private final boolean cacheScores;
        private final LeafBucketCollector[] collectors;
        private int numCollectors;
        private ScoreCachingScorable scorable;

        private MultiLeafBucketCollector(List<LeafBucketCollector> collectors, boolean cacheScores) {
            this.collectors = collectors.toArray(new LeafBucketCollector[0]);
            this.cacheScores = cacheScores;
            this.numCollectors = this.collectors.length;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            if (this.cacheScores) {
                this.scorable = new ScoreCachingScorable(scorer);
            }
            for (int i = 0; i < this.numCollectors; ++i) {
                LeafBucketCollector c = this.collectors[i];
                c.setScorer(this.cacheScores ? this.scorable : scorer);
            }
        }

        private void removeCollector(int i) {
            System.arraycopy(this.collectors, i + 1, this.collectors, i, this.numCollectors - i - 1);
            --this.numCollectors;
            this.collectors[this.numCollectors] = null;
        }

        @Override
        public void collect(int doc, long bucket) throws IOException {
            if (this.scorable != null) {
                this.scorable.setCurDoc(doc);
            }
            LeafBucketCollector[] collectors = this.collectors;
            int numCollectors = this.numCollectors;
            int i = 0;
            while (i < numCollectors) {
                LeafBucketCollector collector = collectors[i];
                try {
                    collector.collect(doc, bucket);
                    ++i;
                }
                catch (CollectionTerminatedException e) {
                    this.removeCollector(i);
                    numCollectors = this.numCollectors;
                    if (numCollectors != 0) continue;
                    throw new CollectionTerminatedException();
                }
            }
        }
    }
}

