/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.breaker.CircuitBreaker;
import io.skylite.core.common.breaker.CircuitBreakingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntConsumer;

public class MultiBucketConsumerService {
    public static final int DEFAULT_MAX_BUCKETS = 65535;
    public static final Setting<Integer> MAX_BUCKET_SETTING = Setting.intSetting("search.max_buckets", 65535, 0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final CircuitBreaker breaker;
    private volatile int maxBucket;

    public MultiBucketConsumerService(ClusterService clusterService, Settings settings, CircuitBreaker breaker) {
        this.breaker = breaker;
        this.maxBucket = MAX_BUCKET_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_BUCKET_SETTING, this::setMaxBucket);
    }

    private void setMaxBucket(int maxBucket) {
        this.maxBucket = maxBucket;
    }

    public MultiBucketConsumer create() {
        return new MultiBucketConsumer(this.maxBucket, this.breaker);
    }

    public static class MultiBucketConsumer
    implements IntConsumer {
        private final int limit;
        private final CircuitBreaker breaker;
        private int count;
        private final LongAdder callCount;
        private volatile boolean circuitBreakerTripped;
        private final int availProcessors;

        public MultiBucketConsumer(int limit, CircuitBreaker breaker) {
            this.limit = limit;
            this.breaker = breaker;
            this.callCount = new LongAdder();
            this.availProcessors = Runtime.getRuntime().availableProcessors();
        }

        protected MultiBucketConsumer(int limit, CircuitBreaker breaker, LongAdder callCount, boolean circuitBreakerTripped, int availProcessors) {
            this.limit = limit;
            this.breaker = breaker;
            this.callCount = callCount;
            this.circuitBreakerTripped = circuitBreakerTripped;
            this.availProcessors = availProcessors;
        }

        @Override
        public void accept(int value) {
            if (value != 0) {
                this.count += value;
                if (this.count > this.limit) {
                    throw new TooManyBucketsException("Trying to create too many buckets. Must be less than or equal to: [" + this.limit + "] but was [" + this.count + "]. This limit can be set by changing the [" + MAX_BUCKET_SETTING.getKey() + "] cluster level setting.", this.limit);
                }
            }
            this.callCount.increment();
            if (this.circuitBreakerTripped) {
                throw new CircuitBreakingException("Circuit breaker for this consumer has already been tripped by previous invocations. This can happen in case of concurrent segment search when multiple threads are executing the request and one of the thread has already tripped the circuit breaker", this.breaker.getDurability());
            }
            long sum = this.callCount.sum();
            if (sum >= 1024L && (sum & 0x3FFL) <= (long)this.availProcessors) {
                try {
                    this.breaker.addEstimateBytesAndMaybeBreak(0L, "allocated_buckets");
                }
                catch (CircuitBreakingException e) {
                    this.circuitBreakerTripped = true;
                    throw e;
                }
            }
        }

        public void reset() {
            this.count = 0;
        }

        public int getCount() {
            return this.count;
        }

        public int getLimit() {
            return this.limit;
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(MAX_BUCKET_SETTING);
        }
    }

    public static class TooManyBucketsException
    extends AggregationExecutionException {
        private final int maxBuckets;

        public TooManyBucketsException(String message, int maxBuckets) {
            super(message);
            this.maxBuckets = maxBuckets;
        }

        public TooManyBucketsException(StreamInput in) throws IOException {
            super(in);
            this.maxBuckets = in.readInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.maxBuckets);
        }

        public int getMaxBuckets() {
            return this.maxBuckets;
        }

        @Override
        public RestStatus status() {
            return RestStatus.SERVICE_UNAVAILABLE;
        }

        @Override
        protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("max_buckets", this.maxBuckets);
        }

        public static class Registration
        implements SkyliteExceptionProvider<TooManyBucketsException> {
            @Override
            public Class<TooManyBucketsException> getExceptionClass() {
                return TooManyBucketsException.class;
            }

            @Override
            public CheckedFunction<StreamInput, TooManyBucketsException, IOException> getConstructor() {
                return TooManyBucketsException::new;
            }

            @Override
            public Version<?> getVersionAdded() {
                return SkyliteException.UNKNOWN_VERSION_ADDED;
            }

            @Override
            public int getLegacyId() {
                return 149;
            }
        }
    }
}

