/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.common.CheckedFunction;
import io.skylite.core.aggregations.AggregationCollectorManager;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.query.ReduceableSearchResult;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Collector;

public class NonGlobalAggCollectorManagerWithSingleCollector
extends AggregationCollectorManager {
    private final Collector collector = Objects.requireNonNull(super.newCollector(), "collector instance is null");
    private final String collectorName = this.collector.toString();

    public NonGlobalAggCollectorManagerWithSingleCollector(SearchExecutionContext context) throws IOException {
        super(context, (CheckedFunction<SearchExecutionContext, List<Aggregator>, IOException>)((CheckedFunction)context.aggregations().factories()::createTopLevelNonGlobalAggregators), "aggregation");
    }

    @Override
    public Collector newCollector() throws IOException {
        return this.collector;
    }

    @Override
    public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
        assert (collectors.isEmpty()) : "Reduce on NonGlobalAggregationCollectorManagerWithCollector called with non-empty collectors";
        return super.reduce(List.of(this.collector));
    }

    @Override
    public String getCollectorName() {
        return this.collectorName;
    }
}

