/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations.pipeline;

import io.skylite.core.aggregations.InternalAggregation;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class PipelineAggregator {
    private String name;
    private String[] bucketsPaths;
    private Map<String, Object> metadata;

    protected PipelineAggregator(String name, String[] bucketsPaths, Map<String, Object> metadata) {
        this.name = name;
        this.bucketsPaths = bucketsPaths;
        this.metadata = metadata;
    }

    public String name() {
        return this.name;
    }

    public String[] bucketsPaths() {
        return this.bucketsPaths;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public abstract InternalAggregation reduce(InternalAggregation var1, InternalAggregation.ReduceContext var2);

    public static class PipelineTree {
        public static final PipelineTree EMPTY = new PipelineTree(Collections.emptyMap(), Collections.emptyList());
        private final Map<String, PipelineTree> subTrees;
        private final List<PipelineAggregator> aggregators;

        public PipelineTree(Map<String, PipelineTree> subTrees, List<PipelineAggregator> aggregators) {
            this.subTrees = subTrees;
            this.aggregators = aggregators;
        }

        public List<PipelineAggregator> aggregators() {
            return this.aggregators;
        }

        public PipelineTree subTree(String name) {
            return this.subTrees.getOrDefault(name, EMPTY);
        }

        public boolean hasSubTrees() {
            return false == this.subTrees.isEmpty();
        }

        public String toString() {
            return "PipelineTree[" + String.valueOf(this.aggregators) + "," + String.valueOf(this.subTrees) + "]";
        }
    }
}

