/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations.values;

import io.skylite.common.index.fielddata.DocValueBits;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.common.Rounding;
import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.geo.GeoFieldData;
import io.skylite.core.index.fielddata.geo.IndexGeoPointFieldData;
import io.skylite.core.index.fielddata.geo.LeafGeoPointFieldData;
import io.skylite.core.index.fielddata.geo.MultiGeoPointValues;
import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;

public abstract class GeoPointValuesSource
extends ValuesSource {
    public static final GeoPointValuesSource EMPTY = new GeoPointValuesSource(){

        @Override
        public MultiGeoPointValues geoPointValues(LeafReaderContext context) {
            return GeoFieldData.emptyMultiGeoPoints();
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
            return FieldData.emptySortedBinary();
        }
    };

    @Override
    public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
        MultiGeoPointValues geoPoints = this.geoPointValues(context);
        return GeoFieldData.docsWithValue(geoPoints);
    }

    @Override
    public final Function<Rounding, Rounding.Prepared> roundingPreparer() throws IOException {
        throw new AggregationExecutionException("can't round a [GEO_POINT]");
    }

    public abstract MultiGeoPointValues geoPointValues(LeafReaderContext var1);

    public static class Fielddata
    extends GeoPointValuesSource {
        protected final IndexGeoPointFieldData indexFieldData;

        public Fielddata(IndexGeoPointFieldData indexFieldData) {
            this.indexFieldData = indexFieldData;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
            return ((LeafGeoPointFieldData)this.indexFieldData.load(context)).getBytesValues();
        }

        @Override
        public MultiGeoPointValues geoPointValues(LeafReaderContext context) {
            return ((LeafGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
        }
    }
}

