/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations.values;

import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValueType;
import io.skylite.core.aggregations.values.ValueTypeProvider;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.common.time.DateResolution;
import io.skylite.core.index.fielddata.DocValueDateFormatters;
import io.skylite.core.index.fielddata.DocValueFormat;
import java.io.IOException;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;

public enum ValueTypes implements ValueType
{
    STRING(1, "string", "string", CoreValuesSourceType.BYTES, DocValueFormat.RAW),
    LONG(2, "byte|short|integer|long", "long", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    DOUBLE(3, "float|double", "double", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    NUMBER(4, "number", "number", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    DATE(5, "date", "date", CoreValuesSourceType.DATE, new DocValueDateFormatters.DateTime(DateFormatter.getDefaultDateTimeFormatter(), ZoneOffset.UTC, DateResolution.MILLISECONDS)),
    IP(6, "ip", "ip", CoreValuesSourceType.IP, DocValueFormat.IP),
    NUMERIC(7, "numeric", "numeric", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    BOOLEAN(9, "boolean", "boolean", CoreValuesSourceType.BOOLEAN, DocValueFormat.BOOLEAN),
    RANGE(10, "range", "range", CoreValuesSourceType.RANGE, DocValueFormat.RAW),
    UNSIGNED_LONG(11, "unsigned_long", "unsigned_long", CoreValuesSourceType.NUMERIC, DocValueFormat.UNSIGNED_LONG);

    final String description;
    final ValuesSourceType valuesSourceType;
    final DocValueFormat defaultFormat;
    private final byte id;
    private String preferredName;
    public static final ParseField VALUE_TYPE;
    private static List<ValueTypes> numericValueTypes;
    private static List<ValueTypes> stringValueTypes;

    private ValueTypes(byte id, String description, String preferredName, ValuesSourceType valuesSourceType, DocValueFormat defaultFormat) {
        this.id = id;
        this.description = description;
        this.preferredName = preferredName;
        this.valuesSourceType = valuesSourceType;
        this.defaultFormat = defaultFormat;
    }

    @Override
    public String getPreferredName() {
        return this.preferredName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public byte getId() {
        return this.id;
    }

    @Override
    public boolean isA(ValueType valueType) {
        if (numericValueTypes.contains(this)) {
            return numericValueTypes.contains(valueType);
        }
        if (stringValueTypes.contains(this)) {
            return stringValueTypes.contains(valueType);
        }
        return this.equals(valueType);
    }

    @Override
    public DocValueFormat defaultFormat() {
        return this.defaultFormat;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    static {
        VALUE_TYPE = new ParseField("value_type", "valueType");
        numericValueTypes = Arrays.asList(DOUBLE, DATE, LONG, UNSIGNED_LONG, NUMBER, NUMERIC, BOOLEAN);
        stringValueTypes = Arrays.asList(STRING, IP);
    }

    public static class ValueTypeProviderImpl
    implements ValueTypeProvider {
        @Override
        public List<ValueType> getValueTypes() {
            return List.of(STRING, LONG, DOUBLE, NUMBER, DATE, IP, NUMERIC, BOOLEAN, RANGE, UNSIGNED_LONG);
        }

        @Override
        public List<Tuple<List<String>, ValueType>> getLenientTypes() {
            return Arrays.asList(new Tuple(List.of("string"), (Object)STRING), new Tuple(List.of("double", "float"), (Object)DOUBLE), new Tuple(List.of("number", "numeric", "long", "integer", "short", "byte"), (Object)LONG), new Tuple(List.of("unsigned_long"), (Object)UNSIGNED_LONG), new Tuple(List.of("date"), (Object)DATE), new Tuple(List.of("ip"), (Object)IP), new Tuple(List.of("boolean"), (Object)BOOLEAN));
        }
    }
}

