/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.analysis;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.analysis.HunspellService;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import java.util.Locale;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.HunspellStemFilter;

public class HunspellTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Dictionary dictionary;
    private final boolean dedup;
    private final boolean longestOnly;

    public HunspellTokenFilterFactory(IndexSettings indexSettings, String name, Settings settings, HunspellService hunspellService) {
        super(indexSettings, name, settings);
        String locale = settings.get("locale", settings.get("language", settings.get("lang", null)));
        if (locale == null) {
            throw new IllegalArgumentException("missing [locale | language | lang] configuration for hunspell token filter");
        }
        this.dictionary = hunspellService.getDictionary(locale);
        if (this.dictionary == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown hunspell dictionary for locale [%s]", locale));
        }
        this.dedup = settings.getAsBoolean("dedup", true);
        this.longestOnly = settings.getAsBoolean("longest_only", false);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary, this.dedup, this.longestOnly);
    }

    public boolean dedup() {
        return this.dedup;
    }

    public boolean longestOnly() {
        return this.longestOnly;
    }
}

