/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.analysis;

import io.skylite.SkyliteException;
import io.skylite.Version;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PreBuiltCacheFactory {
    private PreBuiltCacheFactory() {
    }

    public static <T> PreBuiltCache<T> getCache(CachingStrategy cachingStrategy) {
        switch (cachingStrategy.ordinal()) {
            case 0: {
                return new PreBuiltCacheStrategyOne();
            }
            case 1: {
                return new PreBuiltCacheStrategyLucene();
            }
            case 2: {
                return new PreBuiltCacheStrategySkylite();
            }
        }
        throw new SkyliteException("No action configured for caching strategy[" + String.valueOf((Object)cachingStrategy) + "]", new Object[0]);
    }

    public static enum CachingStrategy {
        ONE,
        LUCENE,
        OPENSEARCH;

    }

    private static class PreBuiltCacheStrategyOne<T>
    implements PreBuiltCache<T> {
        private T model = null;

        private PreBuiltCacheStrategyOne() {
        }

        @Override
        public T get(Version version) {
            return this.model;
        }

        @Override
        public void put(Version version, T model) {
            this.model = model;
        }

        @Override
        public Collection<T> values() {
            return this.model == null ? Collections.emptySet() : Collections.singleton(this.model);
        }
    }

    private static class PreBuiltCacheStrategyLucene<T>
    implements PreBuiltCache<T> {
        private Map<org.apache.lucene.util.Version, T> mapModel = new HashMap<org.apache.lucene.util.Version, T>(2);

        private PreBuiltCacheStrategyLucene() {
        }

        @Override
        public T get(Version version) {
            return this.mapModel.get(version.luceneVersion);
        }

        @Override
        public void put(Version version, T model) {
            this.mapModel.put(version.luceneVersion, model);
        }

        @Override
        public Collection<T> values() {
            return this.mapModel.values();
        }
    }

    private static class PreBuiltCacheStrategySkylite<T>
    implements PreBuiltCache<T> {
        Map<Version, T> mapModel = new HashMap<Version, T>(2);

        private PreBuiltCacheStrategySkylite() {
        }

        @Override
        public T get(Version version) {
            return this.mapModel.get(version);
        }

        @Override
        public void put(Version version, T model) {
            this.mapModel.put(version, model);
        }

        @Override
        public Collection<T> values() {
            return this.mapModel.values();
        }
    }

    public static interface PreBuiltCache<T> {
        public T get(Version var1);

        public void put(Version var1, T var2);

        public Collection<T> values();
    }
}

